/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.GLib;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphTDB
extends GraphView
implements Closeable,
Sync {
    private final DatasetGraphTDB dataset;
    private static Function<Tuple<NodeId>, Tuple<NodeId>> project4TupleTo3Tuple = item -> {
        if (item.len() != 4) {
            throw new TDBException("Expected a Tuple of 4, got: " + item);
        }
        return TupleFactory.tuple((NodeId)item.get(1), (NodeId)item.get(2), (NodeId)item.get(3));
    };

    public GraphTDB(DatasetGraphTDB dataset, Node graphName) {
        super(dataset, graphName);
        this.dataset = dataset;
    }

    public DatasetGraphTDB getDSG() {
        return this.dataset;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.getDSG().chooseNodeTupleTable(this.getGraphName());
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        if (this.isDefaultGraph()) {
            return this.getDSG().getPrefixes().getPrefixMapping();
        }
        if (this.isUnionGraph()) {
            return this.getDSG().getPrefixes().getPrefixMapping();
        }
        return this.getDSG().getPrefixes().getPrefixMapping(this.getGraphName().getURI());
    }

    @Override
    public final void sync() {
        this.dataset.sync();
    }

    @Override
    public final void close() {
        this.sync();
    }

    @Override
    protected ExtendedIterator<Triple> graphUnionFind(Node s, Node p, Node o) {
        Node g = Quad.unionGraph;
        Iterator<Quad> iterQuads = this.getDSG().find(g, s, p, o);
        Iterator<Triple> iter = GLib.quads2triples(iterQuads);
        iter = Iter.distinctAdjacent(iter);
        return WrappedIterator.createNoRemove(iter);
    }

    @Override
    protected final int graphBaseSize() {
        if (this.isDefaultGraph()) {
            return (int)this.getNodeTupleTable().size();
        }
        Node gn = this.getGraphName();
        boolean unionGraph = GraphTDB.isUnionGraph(gn);
        gn = unionGraph ? Node.ANY : gn;
        Iterator<Tuple<NodeId>> iter = this.getDSG().getQuadTable().getNodeTupleTable().findAsNodeIds(gn, null, null, null);
        if (unionGraph) {
            iter = Iter.map(iter, project4TupleTo3Tuple);
            iter = Iter.distinctAdjacent(iter);
        }
        return (int)Iter.count(iter);
    }

    @Override
    public void clear() {
        this.dataset.deleteAny(this.getGraphName(), Node.ANY, Node.ANY, Node.ANY);
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        if (this.getEventManager().listening()) {
            super.remove(s, p, o);
            return;
        }
        this.dataset.deleteAny(this.getGraphName(), s, p, o);
    }
}

