/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.tdb.sys.DatasetControl;

public class DatasetControlMRSW
implements DatasetControl {
    private final boolean concurrencyChecking = true;
    private final AtomicLong epoch = new AtomicLong(5L);
    private final AtomicLong readCounter = new AtomicLong(0L);
    private final AtomicLong writeCounter = new AtomicLong(0L);

    @Override
    public void startRead() {
        this.readCounter.getAndIncrement();
        this.checkConcurrency();
    }

    @Override
    public void finishRead() {
        this.readCounter.decrementAndGet();
    }

    @Override
    public void startUpdate() {
        this.epoch.getAndIncrement();
        this.writeCounter.getAndIncrement();
        this.checkConcurrency();
    }

    @Override
    public void finishUpdate() {
        this.writeCounter.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConcurrency() {
        long W2;
        long R;
        DatasetControlMRSW datasetControlMRSW = this;
        synchronized (datasetControlMRSW) {
            R = this.readCounter.get();
            W2 = this.writeCounter.get();
        }
        if (R > 0L && W2 > 0L) {
            DatasetControlMRSW.policyError(R, W2);
        }
        if (W2 > 1L) {
            DatasetControlMRSW.policyError(R, W2);
        }
    }

    @Override
    public <T> Iterator<T> iteratorControl(Iterator<T> iter) {
        return new IteratorCheckNotConcurrent<T>(iter, this.epoch);
    }

    private static void policyError(long R, long W2) {
        DatasetControlMRSW.policyError(String.format("Reader = %d, Writer = %d", R, W2));
    }

    private static void policyError(String message) {
        throw new ConcurrentModificationException(message);
    }

    private static class IteratorCheckNotConcurrent<T>
    implements Iterator<T>,
    Closeable {
        private Iterator<T> iter;
        private AtomicLong eCount;
        private boolean finished = false;
        private long startEpoch;

        IteratorCheckNotConcurrent(Iterator<T> iter, AtomicLong eCount) {
            this.iter = iter;
            this.eCount = eCount;
            this.startEpoch = eCount.get();
        }

        private void checkIterConcurrentModification() {
            if (this.finished) {
                return;
            }
            long now2 = this.eCount.get();
            if (now2 != this.startEpoch) {
                DatasetControlMRSW.policyError(String.format("Iterator: started at %d, now %d", this.startEpoch, now2));
            }
        }

        @Override
        public boolean hasNext() {
            this.checkIterConcurrentModification();
            boolean b = this.iter.hasNext();
            if (!b) {
                this.close();
            }
            return b;
        }

        @Override
        public T next() {
            this.checkIterConcurrentModification();
            try {
                return this.iter.next();
            }
            catch (NoSuchElementException ex) {
                this.close();
                throw ex;
            }
        }

        @Override
        public void remove() {
            this.checkIterConcurrentModification();
            this.iter.remove();
        }

        @Override
        public void close() {
            this.finished = true;
            Iter.close(this.iter);
        }
    }
}

