/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.nodetable;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.io.BlockUTF8;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapNull;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.riot.web.LangTag;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.lib.StringAbbrev;
import org.apache.jena.tdb.store.nodetable.Nodec;

public class NodecSSE
implements Nodec {
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};
    private static final PrefixMap pmap0 = PrefixMapNull.empty;
    private static final boolean onlySafeBNodeLabels = false;
    public static final boolean compression = false;
    private static StringAbbrev abbreviations = new StringAbbrev();

    @Override
    public int maxSize(Node node) {
        return NodecSSE.maxLength(node);
    }

    @Override
    public int encode(Node node, ByteBuffer bb, PrefixMapping pmap) {
        String lang;
        String x;
        String str2 = null;
        if (node.isURI() && (x = StrUtils.encodeHex(node.getURI(), '_', invalidIRIChars)) != node.getURI()) {
            node = NodeFactory.createURI(x);
        }
        if (node.isLiteral() && NodeUtils.isLangString(node) && !LangTag.check(lang = node.getLiteralLanguage())) {
            throw new TDBException("bad language tag: " + node);
        }
        if (node.isBlank()) {
            str2 = "_:" + node.getBlankNodeLabel();
        }
        if (str2 == null) {
            str2 = NodeFmtLib.str(node, null, pmap0);
        }
        BlockUTF8.fromChars(str2, bb);
        bb.flip();
        return bb.limit();
    }

    @Override
    public Node decode(ByteBuffer bb, PrefixMapping pmap) {
        String str2 = BlockUTF8.toString(bb);
        if (str2.startsWith("_:")) {
            str2 = str2.substring(2);
            return NodeFactory.createBlankNode(str2);
        }
        if (str2.startsWith("<")) {
            str2 = str2.substring(1, str2.length() - 1);
            str2 = StrUtils.unescapeString(str2);
            str2 = StrUtils.decodeHex(str2, '_');
            return NodeFactory.createURI(str2);
        }
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(str2);
        if (!tokenizer.hasNext()) {
            throw new TDBException("Failed to tokenise: " + str2);
        }
        Token t = tokenizer.next();
        try {
            Node n = t.asNode();
            if (n == null) {
                throw new TDBException("Not a node: " + str2);
            }
            return n;
        }
        catch (RiotException ex) {
            throw new TDBException("Bad string for node: " + str2);
        }
    }

    private static int maxLength(Node node) {
        if (node.isBlank()) {
            return 2 + NodecSSE.maxLength(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            return 2 + NodecSSE.maxLength(node.getURI());
        }
        if (node.isLiteral()) {
            int len = 2 + NodecSSE.maxLength(node.getLiteralLexicalForm());
            if (NodeUtils.isLangString(node)) {
                len = len + 3 + node.getLiteralLanguage().length();
            } else if (!NodeUtils.isSimpleString(node)) {
                len = len + 4 + NodecSSE.maxLength(node.getLiteralDatatypeURI());
            }
            return len;
        }
        if (node.isVariable()) {
            return 1 + NodecSSE.maxLength(node.getName());
        }
        throw new TDBException("Unrecognized node type: " + node);
    }

    private static int maxLength(String string) {
        return string.length() * 3;
    }

    private String compress(String str2) {
        return str2;
    }

    private String decompress(String x) {
        return x;
    }

    static {
        abbreviations.add("rdf", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        abbreviations.add("rdfs", "<http://www.w3.org/2000/01/rdf-schema#");
        abbreviations.add("xsd", "<http://www.w3.org/2001/XMLSchema#");
        abbreviations.add("mal", "<http://musicbrainz.org/mm-2.1/album/");
        abbreviations.add("mt", "<http://musicbrainz.org/mm-2.1/track/");
        abbreviations.add("mar", "<http://musicbrainz.org/mm-2.1/artist/");
        abbreviations.add("mtr", "<http://musicbrainz.org/mm-2.1/trmid/");
        abbreviations.add("mc", "<http://musicbrainz.org/mm-2.1/cdindex/");
        abbreviations.add("m21", "<http://musicbrainz.org/mm/mm-2.1#");
        abbreviations.add("dc", "<http://purl.org/dc/elements/1.1/");
        abbreviations.add("r", "<http://dbpedia/resource/");
        abbreviations.add("p", "<http://dbpedia/property/");
    }
}

