/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.migrate.A2;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;

public class QueryEngineTDB
extends QueryEngineMain {
    protected static QueryEngineFactory factory = new QueryEngineFactoryTDB();

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }

    protected QueryEngineTDB(Op op, DatasetGraphTDB dataset, Binding input, Context context) {
        super(op, (DatasetGraph)dataset, input, context);
    }

    protected QueryEngineTDB(Query query2, DatasetGraphTDB dataset, Binding input, Context cxt) {
        super(query2, (DatasetGraph)dataset, input, cxt);
    }

    @Override
    protected DatasetGraph dynamicDataset(DatasetDescription dsDesc, DatasetGraph dataset, boolean unionDftGraph) {
        boolean union = unionDftGraph || this.context.isTrue(TDB.symUnionDefaultGraph);
        return DynamicDatasets.dynamicDataset(dsDesc, dataset, union);
    }

    @Override
    protected Op modifyOp(Op op) {
        op = Substitute.substitute(op, this.getStartBinding());
        op = super.modifyOp(op);
        if (!this.isDynamicDataset()) {
            op = Algebra.toQuadForm(op);
        }
        this.setOp(op);
        return op;
    }

    @Override
    public QueryIterator eval(Op op, DatasetGraph dsg, Binding input, Context context) {
        if (context.isTrue(TDB.symUnionDefaultGraph) && !this.isDynamicDataset()) {
            op = A2.unionDefaultGraphQuads(op);
            Explain.explain("REWRITE(Union default graph)", op, context);
        }
        QueryIterator results = super.eval(op, dsg, input, context);
        return results;
    }

    protected static class QueryEngineFactoryTDB
    implements QueryEngineFactory {
        protected QueryEngineFactoryTDB() {
        }

        private static boolean isHandledByTDB(DatasetGraph dataset) {
            if (dataset instanceof DatasetGraphTDB) {
                return true;
            }
            return dataset instanceof DatasetGraphTransaction;
        }

        protected DatasetGraphTDB dsgToQuery(DatasetGraph dataset) {
            if (dataset instanceof DatasetGraphTDB) {
                return (DatasetGraphTDB)dataset;
            }
            if (dataset instanceof DatasetGraphTransaction) {
                return ((DatasetGraphTransaction)dataset).getDatasetGraphToQuery();
            }
            throw new TDBException("Internal inconsistency: trying to execute query on unrecognized kind of DatasetGraph: " + Lib.className(dataset));
        }

        @Override
        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        @Override
        public Plan create(Query query2, DatasetGraph dataset, Binding input, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(query2, this.dsgToQuery(dataset), input, context);
            return engine.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(op, this.dsgToQuery(dataset), binding, context);
            return engine.getPlan();
        }
    }
}

