/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.recordbuffer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Alg;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.base.StorageException;
import org.apache.jena.tdb.base.block.BlockException;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.recordbuffer.RecordBufferPage;
import org.apache.jena.tdb.base.recordbuffer.RecordBufferPageMgr;

public final class RecordRangeIterator
implements Iterator<Record>,
Closeable {
    private RecordBufferPage currentPage;
    private int currentIdx = 0;
    private Record slot = null;
    private final RecordBufferPageMgr pageMgr;
    private final Record maxRec;
    private final Record minRec;
    private long countRecords = 0L;
    private long countBlocks = 0L;

    public static Iterator<Record> iterator(int pageId, Record fromRec, Record toRec, RecordBufferPageMgr pageMgr) {
        if (!pageMgr.valid(pageId)) {
            String msg = "RecordRangeIterator.iterator -- No such block (pageId=" + pageId + ", fromRec=" + fromRec + ", toRec=" + toRec + ")";
            Log.error(RecordRangeIterator.class, msg);
            throw new BlockException(msg);
        }
        return new RecordRangeIterator(pageId, fromRec, toRec, pageMgr);
    }

    private RecordRangeIterator(int id, Record fromRec, Record toRec, RecordBufferPageMgr pageMgr) {
        this.pageMgr = pageMgr;
        this.minRec = fromRec;
        this.maxRec = toRec;
        if (toRec != null && fromRec != null && Record.keyLE(toRec, fromRec)) {
            this.currentPage = null;
            return;
        }
        pageMgr.getBlockMgr().beginIterator(this);
        this.currentPage = pageMgr.getReadIterator(id);
        if (this.currentPage.getCount() == 0) {
            this.close();
            return;
        }
        if (fromRec != null) {
            this.currentIdx = this.currentPage.getRecordBuffer().find(fromRec);
            if (this.currentIdx < 0) {
                this.currentIdx = Alg.decodeIndex(this.currentIdx);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.slot != null) {
            return true;
        }
        if (this.currentPage == null) {
            return false;
        }
        while (this.currentIdx >= this.currentPage.getCount()) {
            Record r2;
            int link = this.currentPage.getLink();
            if (link < 0) {
                this.close();
                return false;
            }
            if (this.currentPage != null) {
                this.pageMgr.release(this.currentPage);
            }
            RecordBufferPage nextPage = this.pageMgr.getReadIterator(link);
            Record r1 = this.currentPage.getRecordBuffer().getHigh();
            if (Record.keyGE(r1, r2 = nextPage.getRecordBuffer().getLow())) {
                throw new StorageException("RecordRangeIterator: records not strictly increasing: " + r1 + " // " + r2);
            }
            this.currentPage = nextPage;
            ++this.countBlocks;
            this.currentIdx = 0;
        }
        this.slot = this.currentPage.getRecordBuffer().get(this.currentIdx);
        ++this.currentIdx;
        if (this.maxRec != null && Record.keyGE(this.slot, this.maxRec)) {
            this.close();
            return false;
        }
        if (this.slot == null) {
            this.close();
            return false;
        }
        ++this.countRecords;
        return true;
    }

    @Override
    public void close() {
        if (this.currentPage != null) {
            this.pageMgr.release(this.currentPage);
        }
        this.currentPage = null;
        this.currentIdx = -99;
        this.slot = null;
        this.pageMgr.getBlockMgr().endIterator(this);
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Record x = this.slot;
        this.slot = null;
        return x;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public final long getCountRecords() {
        return this.countRecords;
    }

    public final long getCountBlocks() {
        return this.countBlocks;
    }
}

