/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ext.com.google.common.base.Strings;
import org.apache.jena.ext.com.google.common.collect.LinkedListMultimap;
import org.apache.jena.ext.com.google.common.collect.ListMultimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSlice;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextQueryPF
extends PropertyFunctionBase {
    private static Logger log = LoggerFactory.getLogger(TextQueryPF.class);
    private TextIndex textIndex = null;
    private boolean warningIssued = false;
    private static final Symbol cacheSymbol = Symbol.create("TextQueryPF.cache");
    private static final int CACHE_SIZE = 10;

    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        int size;
        super.build(argSubject, predicate, argObject, execCxt);
        DatasetGraph dsg = execCxt.getDataset();
        this.textIndex = TextQueryPF.chooseTextIndex(execCxt, dsg);
        if (argSubject.isList() && ((size = argSubject.getArgListSize()) == 0 || size > 4)) {
            throw new QueryBuildException("Subject has " + argSubject.getArgList().size() + " elements, must be at least 1 and not greater than 4: " + argSubject);
        }
        if (argObject.isList()) {
            List<Node> list = argObject.getArgList();
            if (list.size() == 0) {
                throw new QueryBuildException("Zero-length argument list");
            }
            if (list.size() > 5) {
                throw new QueryBuildException("Too many arguments in list : " + list);
            }
        }
    }

    private static TextIndex chooseTextIndex(ExecutionContext execCxt, DatasetGraph dsg) {
        Object obj = execCxt.getContext().get(TextQuery.textIndex);
        if (obj != null) {
            try {
                return (TextIndex)obj;
            }
            catch (ClassCastException ex) {
                Log.warn(TextQueryPF.class, "Context setting '" + TextQuery.textIndex + "'is not a TextIndex");
            }
        }
        if (dsg instanceof DatasetGraphText) {
            DatasetGraphText x = (DatasetGraphText)dsg;
            return x.getTextIndex();
        }
        Log.warn(TextQueryPF.class, "Failed to find the text index : tried context and as a text-enabled dataset");
        return null;
    }

    private String extractArg(String prefix, List<Node> objArgs) {
        String value = null;
        for (Node node : objArgs) {
            String arg;
            if (!node.isLiteral() || !(arg = node.getLiteral().toString()).startsWith(prefix + ":")) continue;
            value = arg.substring(prefix.length() + 1);
            break;
        }
        return value;
    }

    @Override
    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterator qIter;
        if (log.isTraceEnabled()) {
            IndentedLineBuffer subjBuff = new IndentedLineBuffer();
            argSubject.output(subjBuff, null);
            IndentedLineBuffer objBuff = new IndentedLineBuffer();
            argObject.output(objBuff, null);
            log.trace("exec: {} text:query {}", (Object)subjBuff, (Object)objBuff);
        }
        if (this.textIndex == null) {
            if (!this.warningIssued) {
                Log.warn(this.getClass(), "No text index - no text search performed");
                this.warningIssued = true;
            }
            return IterLib.result(binding, execCxt);
        }
        argSubject = Substitute.substitute(argSubject, binding);
        argObject = Substitute.substitute(argObject, binding);
        Node s = null;
        Node score = null;
        Node literal = null;
        Node graph = null;
        if (argSubject.isList()) {
            s = argSubject.getArg(0);
            if (argSubject.getArgListSize() > 1 && !(score = argSubject.getArg(1)).isVariable()) {
                throw new QueryExecException("Hit score is not a variable: " + argSubject);
            }
            if (argSubject.getArgListSize() > 2 && !(literal = argSubject.getArg(2)).isVariable()) {
                throw new QueryExecException("Hit literal is not a variable: " + argSubject);
            }
            if (argSubject.getArgListSize() > 3 && !(graph = argSubject.getArg(3)).isVariable()) {
                throw new QueryExecException("Hit graph is not a variable: " + argSubject);
            }
        } else {
            s = argSubject.getArg();
        }
        if (s.isLiteral()) {
            return IterLib.noResults(execCxt);
        }
        StrMatch match = this.objectToStruct(argObject, true);
        if (match == null) {
            return IterLib.noResults(execCxt);
        }
        QueryIterator queryIterator = qIter = Var.isVar(s) ? this.variableSubject(binding, s, score, literal, graph, match, execCxt) : this.concreteSubject(binding, s, score, literal, graph, match, execCxt);
        if (match.getLimit() >= 0) {
            qIter = new QueryIterSlice(qIter, 0L, match.getLimit(), execCxt);
        }
        return qIter;
    }

    private QueryIterator resultsToQueryIterator(Binding binding, Node s, Node score, Node literal, Node graph, Collection<TextHit> results, ExecutionContext execCxt) {
        log.trace("resultsToQueryIterator: {}", (Object)results);
        Var sVar = Var.isVar(s) ? Var.alloc(s) : null;
        Var scoreVar = score == null ? null : Var.alloc(score);
        Var literalVar = literal == null ? null : Var.alloc(literal);
        Var graphVar = graph == null ? null : Var.alloc(graph);
        Function<TextHit, Binding> converter = hit -> {
            if (score == null && literal == null) {
                return sVar != null ? BindingFactory.binding(binding, sVar, hit.getNode()) : BindingFactory.binding(binding);
            }
            BindingMap bmap = BindingFactory.create(binding);
            if (sVar != null) {
                bmap.add(sVar, hit.getNode());
            }
            if (scoreVar != null) {
                bmap.add(scoreVar, NodeFactoryExtra.floatToNode(hit.getScore()));
            }
            if (literalVar != null) {
                bmap.add(literalVar, hit.getLiteral());
            }
            if (graphVar != null && hit.getGraph() != null) {
                bmap.add(graphVar, hit.getGraph());
            }
            return bmap;
        };
        Iterator<Binding> bIter = Iter.map(results.iterator(), converter);
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bIter, execCxt);
        return qIter;
    }

    private QueryIterator variableSubject(Binding binding, Node s, Node score, Node literal, Node graph, StrMatch match, ExecutionContext execCxt) {
        log.trace("variableSubject: {}", (Object)match);
        ListMultimap<String, TextHit> results = this.query(match.getProperty(), match.getQueryString(), match.getLang(), match.getLimit(), match.getHighlight(), execCxt);
        Collection<TextHit> r = results.values();
        return this.resultsToQueryIterator(binding, s, score, literal, graph, r, execCxt);
    }

    private QueryIterator concreteSubject(Binding binding, Node s, Node score, Node literal, Node graph, StrMatch match, ExecutionContext execCxt) {
        log.trace("concreteSubject: {}", (Object)match);
        ListMultimap<String, TextHit> x = s instanceof Node_URI ? this.query(s.getURI(), match.getProperty(), match.getQueryString(), match.getLang(), -1, match.getHighlight(), execCxt) : this.query(match.getProperty(), match.getQueryString(), match.getLang(), -1, match.getHighlight(), execCxt);
        if (x == null) {
            return IterLib.noResults(execCxt);
        }
        Collection r = x.get((Object)TextQueryFuncs.subjectToString(s));
        return this.resultsToQueryIterator(binding, s, score, literal, graph, r, execCxt);
    }

    private ListMultimap<String, TextHit> query(Node property, String queryString, String lang, int limit, String highlight, ExecutionContext execCxt) {
        String graphURI = this.chooseGraphURI(execCxt);
        this.explainQuery(queryString, limit, execCxt, graphURI);
        if (this.textIndex.getDocDef().areQueriesCached()) {
            String cacheKey = limit + " " + property + " " + queryString + " " + lang + " " + graphURI;
            Cache<String, ListMultimap<String, TextHit>> queryCache = this.prepareCache(execCxt);
            log.trace("Caching Text query: {} with key: >>{}<< in cache: {}", queryString, cacheKey, queryCache);
            return queryCache.getOrFill(cacheKey, () -> this.performQuery(property, queryString, graphURI, lang, limit, highlight));
        }
        log.trace("Executing w/o cache Text query: {}", (Object)queryString);
        return this.performQuery(property, queryString, graphURI, lang, limit, highlight);
    }

    private ListMultimap<String, TextHit> query(String uri, Node property, String queryString, String lang, int limit, String highlight, ExecutionContext execCxt) {
        String graphURI = this.chooseGraphURI(execCxt);
        this.explainQuery(queryString, limit, execCxt, graphURI);
        if (this.textIndex.getDocDef().areQueriesCached()) {
            String cacheKey = uri + " " + limit + " " + property + " " + queryString + " " + lang + " " + graphURI;
            Cache<String, ListMultimap<String, TextHit>> queryCache = this.prepareCache(execCxt);
            log.trace("Caching Text query: {} with key: >>{}<< in cache: {}", queryString, cacheKey, queryCache);
            return queryCache.getOrFill(cacheKey, () -> this.performQuery(uri, property, queryString, graphURI, lang, limit, highlight));
        }
        log.trace("Executing w/o cache Text query: {}", (Object)queryString);
        return this.performQuery(uri, property, queryString, graphURI, lang, limit, highlight);
    }

    private Cache<String, ListMultimap<String, TextHit>> prepareCache(ExecutionContext execCxt) {
        Cache queryCache = (Cache)execCxt.getContext().get(cacheSymbol);
        if (queryCache == null) {
            queryCache = CacheFactory.createCache(10);
            execCxt.getContext().put(cacheSymbol, queryCache);
        }
        return queryCache;
    }

    private void explainQuery(String queryString, int limit, ExecutionContext execCxt, String graphURI) {
        if (graphURI == null) {
            Explain.explain(execCxt.getContext(), "Text query: " + queryString);
            log.debug("Text query: {} ({})", (Object)queryString, (Object)limit);
        } else {
            Explain.explain(execCxt.getContext(), "Text query <" + graphURI + ">: " + queryString);
            log.debug("Text query: {} <{}> ({})", queryString, graphURI, limit);
        }
    }

    private String chooseGraphURI(ExecutionContext execCxt) {
        NamedGraph namedGraph;
        String graphURI = null;
        Graph activeGraph = execCxt.getActiveGraph();
        if (this.textIndex.getDocDef().getGraphField() != null && activeGraph instanceof NamedGraph && !Quad.isUnionGraph((namedGraph = (NamedGraph)activeGraph).getGraphName())) {
            graphURI = namedGraph.getGraphName() != null ? TextQueryFuncs.graphNodeToString(namedGraph.getGraphName()) : Quad.defaultGraphNodeGenerated.getURI();
        }
        return graphURI;
    }

    private ListMultimap<String, TextHit> performQuery(Node property, String queryString, String graphURI, String lang, int limit, String highlight) {
        List<TextHit> resultList = this.textIndex.query(property, queryString, graphURI, lang, limit, highlight);
        return this.mapResult(resultList);
    }

    private ListMultimap<String, TextHit> performQuery(String uri, Node property, String queryString, String graphURI, String lang, int limit, String highlight) {
        List<TextHit> resultList = this.textIndex.query(uri, property, queryString, graphURI, lang, limit, highlight);
        return this.mapResult(resultList);
    }

    private ListMultimap<String, TextHit> mapResult(List<TextHit> resultList) {
        LinkedListMultimap<String, TextHit> results = LinkedListMultimap.create();
        for (TextHit result : resultList) {
            results.put(TextQueryFuncs.subjectToString(result.getNode()), result);
        }
        return results;
    }

    private StrMatch objectToStruct(PropFuncArg argObject, boolean executionTime) {
        EntityDefinition docDef = this.textIndex.getDocDef();
        if (argObject.isNode()) {
            Node o = argObject.getArg();
            if (!o.isLiteral()) {
                if (executionTime) {
                    log.warn("Object to text query is not a literal");
                }
                return null;
            }
            String lang = o.getLiteralLanguage();
            RDFDatatype dt = o.getLiteralDatatype();
            if (lang.isEmpty() && dt != null && dt != XSDDatatype.XSDstring) {
                log.warn("Object to text query is not a string");
                return null;
            }
            lang = Strings.emptyToNull(lang);
            String qs = o.getLiteralLexicalForm();
            return new StrMatch(null, qs, lang, -1, 0.0f, null);
        }
        List<Node> list = argObject.getArgList();
        if (list.size() == 0 || list.size() > 5) {
            throw new TextIndexException("Change in object list size");
        }
        Node predicate = null;
        String field = null;
        int idx = 0;
        Node x = list.get(0);
        if (x.isURI()) {
            predicate = x;
            if (++idx >= list.size()) {
                throw new TextIndexException("Property specificed but no query string : " + list);
            }
            x = list.get(idx);
            field = docDef.getField(predicate);
            if (field == null) {
                log.warn("Predicate not indexed: " + predicate);
                return null;
            }
        }
        if (!x.isLiteral()) {
            if (executionTime) {
                log.warn("Text query string is not a literal " + list);
            }
            return null;
        }
        String lang = x.getLiteralLanguage();
        if (lang.isEmpty() && x.getLiteralDatatype() != null && !x.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            log.warn("Text query is not a string " + list);
            return null;
        }
        lang = Strings.emptyToNull(lang);
        String queryString = x.getLiteralLexicalForm();
        int limit = -1;
        float score = 0.0f;
        if (++idx < list.size()) {
            x = list.get(idx);
            ++idx;
            if (!x.isLiteral()) {
                if (executionTime) {
                    log.warn("Text query limit is not an integer " + x);
                }
                return null;
            }
            int v = NodeFactoryExtra.nodeToInt(x);
            limit = v < 0 ? -1 : v;
        }
        String string = lang = lang == null ? this.extractArg("lang", list) : lang;
        if (lang != null && this.textIndex.getDocDef().getLangField() == null) {
            log.warn("lang argument is ignored if langField not set in the index configuration");
        }
        String highlight = this.extractArg("highlight", list);
        return new StrMatch(predicate, queryString, lang, limit, score, highlight);
    }

    class StrMatch {
        private final Node property;
        private final String queryString;
        private final String lang;
        private final int limit;
        private final float scoreLimit;
        private final String highlight;

        public StrMatch(Node property, String queryString, String lang, int limit, float scoreLimit, String highlight) {
            this.property = property;
            this.queryString = queryString;
            this.lang = lang;
            this.limit = limit;
            this.scoreLimit = scoreLimit;
            this.highlight = highlight;
        }

        public Node getProperty() {
            return this.property;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getLang() {
            return this.lang;
        }

        public int getLimit() {
            return this.limit;
        }

        public float getScoreLimit() {
            return this.scoreLimit;
        }

        public String getHighlight() {
            return this.highlight;
        }

        public String toString() {
            return "( property: " + this.property + "; query: " + this.queryString + "; limit: " + this.limit + "; lang: " + this.lang + "; maxFrags: " + this.highlight + " )";
        }
    }
}

