/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial.assembler;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class EntityDefinitionAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public EntityDefinition open(Assembler a, Resource root2, Mode mode) {
        String prologue = "PREFIX : <http://jena.apache.org/spatial#>   PREFIX list: <http://jena.apache.org/ARQ/list#> ";
        Model model = root2.getModel();
        String qs1 = StrUtils.strjoinNL(prologue, "SELECT * {", "  ?definition  :entityField  ?entityField ;", "               :geoField ?geoField", "}");
        ParameterizedSparqlString pss = new ParameterizedSparqlString(qs1);
        pss.setIri("definition", root2.getURI());
        Query query1 = QueryFactory.create(pss.toString());
        QueryExecution qexec1 = QueryExecutionFactory.create(query1, model);
        ResultSet rs1 = qexec1.execSelect();
        List<QuerySolution> results = ResultSetFormatter.toList(rs1);
        if (results.size() == 0) {
            throw new SpatialIndexException("Failed to find a valid EntityDefinition for : " + root2);
        }
        if (results.size() != 1) {
            Log.warn(this, "Multiple matches for EntityMap for : " + root2);
            throw new SpatialIndexException("Multiple matches for EntityDefinition for : " + root2);
        }
        QuerySolution qsol1 = results.get(0);
        String entityField = qsol1.getLiteral("entityField").getLexicalForm();
        String geoField = qsol1.getLiteral("geoField").getLexicalForm();
        EntityDefinition docDef = new EntityDefinition(entityField, geoField);
        String qs2 = StrUtils.strjoinNL("SELECT * { ?definition :hasSpatialPredicatePairs [ list:member [ :latitude ?latitude ; :longitude ?longitude ] ]}");
        Query query2 = QueryFactory.create(prologue + " " + qs2);
        QueryExecution qexec2 = QueryExecutionFactory.create(query2, model, qsol1);
        ResultSet rs2 = qexec2.execSelect();
        List<QuerySolution> mapEntries = ResultSetFormatter.toList(rs2);
        for (QuerySolution qsol : mapEntries) {
            Resource latitude = qsol.getResource("latitude");
            Resource longitude = qsol.getResource("longitude");
            docDef.addSpatialPredicatePair(latitude, longitude);
        }
        String qs3 = StrUtils.strjoinNL("SELECT * { ?definition :hasWKTPredicates [ list:member ?wkt ] }");
        Query query3 = QueryFactory.create(prologue + " " + qs3);
        QueryExecution qexec3 = QueryExecutionFactory.create(query3, model, qsol1);
        ResultSet rs3 = qexec3.execSelect();
        mapEntries = ResultSetFormatter.toList(rs3);
        for (QuerySolution qsol : mapEntries) {
            Resource wkt = qsol.getResource("wkt");
            docDef.addWKTPredicate(wkt);
        }
        String qs4 = StrUtils.strjoinNL("SELECT * { ?definition :spatialContextFactory ?factory }");
        Query query4 = QueryFactory.create(prologue + " " + qs4);
        QueryExecution qexec4 = QueryExecutionFactory.create(query4, model, qsol1);
        ResultSet rs4 = qexec4.execSelect();
        List<QuerySolution> results4 = ResultSetFormatter.toList(rs4);
        if (results4.size() == 0) {
            return docDef;
        }
        if (results4.size() != 1) {
            Log.warn(this, "Multiple matches for SpatialContextFactory for : " + root2);
            throw new SpatialIndexException("Multiple matches for SpatialContextFactory for : " + root2);
        }
        QuerySolution qsol4 = results4.get(0);
        String spatialContextFactory = qsol4.getLiteral("factory").getLexicalForm();
        try {
            docDef.setSpatialContextFactory(spatialContextFactory);
        }
        catch (NoClassDefFoundError e2) {
            Log.warn(this, "Custom SpatialContextFactory lib is not ready in classpath:" + e2.getMessage());
        }
        return docDef;
    }
}

