/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import org.apache.jena.graph.Node;
import org.apache.jena.query.spatial.SpatialDocProducer;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexContext;
import org.apache.jena.sparql.core.QuadAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialDocProducerTriples
implements SpatialDocProducer {
    private static Logger log = LoggerFactory.getLogger(SpatialDocProducerTriples.class);
    private final SpatialIndex indexer;
    private boolean started = false;
    private SpatialIndexContext context = null;

    public SpatialDocProducerTriples(SpatialIndex indexer) {
        this.indexer = indexer;
        this.context = new SpatialIndexContext(indexer);
    }

    @Override
    public void start() {
        this.indexer.startIndexing();
        this.started = true;
    }

    @Override
    public void finish() {
        this.indexer.finishIndexing();
    }

    @Override
    public void change(QuadAction qaction, Node g, Node s, Node p, Node o) {
        if (qaction != QuadAction.ADD) {
            return;
        }
        this.context.index(g, s, p, o);
    }

    @Override
    public void reset() {
    }
}

