/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.spatial4j.distance.DistanceUtils;

public class DistanceUnitsUtils {
    public static final String defaultDistanceUnit = "kilometres";
    public static final List<String> SUPPORTED_UNITS = new ArrayList<String>();

    public static double dist2Degrees(double dist, String units) {
        double degrees = dist;
        if (units.equals("kilometers") || units.equals(defaultDistanceUnit) || units.equals("km")) {
            return DistanceUtils.dist2Degrees(dist, 6371.0087714);
        }
        if (units.equals("meters") || units.equals("metres") || units.equals("m")) {
            return DistanceUtils.dist2Degrees(dist / 1000.0, 6371.0087714);
        }
        if (units.equals("centimeters") || units.equals("centimetres") || units.equals("cm")) {
            return DistanceUtils.dist2Degrees(dist / 100000.0, 6371.0087714);
        }
        if (units.equals("millimeters") || units.equals("millimetres") || units.equals("mm") || units.equals("milimeters") || units.equals("milimetres")) {
            return DistanceUtils.dist2Degrees(dist / 1000000.0, 6371.0087714);
        }
        if (units.equals("miles") || units.equals("mi")) {
            return DistanceUtils.dist2Degrees(dist, 3958.7613145272735);
        }
        if (units.equals("degrees") || units.equals("de")) {
            return degrees;
        }
        throw new IllegalArgumentException("unknow distance units: " + units);
    }

    public static boolean isSupportedUnits(String units) {
        return SUPPORTED_UNITS.contains(units);
    }

    static {
        SUPPORTED_UNITS.add(defaultDistanceUnit);
        SUPPORTED_UNITS.add("kilometers");
        SUPPORTED_UNITS.add("km");
        SUPPORTED_UNITS.add("meters");
        SUPPORTED_UNITS.add("metres");
        SUPPORTED_UNITS.add("m");
        SUPPORTED_UNITS.add("centimeters");
        SUPPORTED_UNITS.add("centimetres");
        SUPPORTED_UNITS.add("cm");
        SUPPORTED_UNITS.add("millimetres");
        SUPPORTED_UNITS.add("millimeters");
        SUPPORTED_UNITS.add("mm");
        SUPPORTED_UNITS.add("miles");
        SUPPORTED_UNITS.add("mi");
        SUPPORTED_UNITS.add("degrees");
        SUPPORTED_UNITS.add("de");
    }
}

