/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class ServiceRouter
extends ActionService {
    public ServiceRouter() {
        super((HttpAction action, Operation operation) -> action.getServiceDispatchRegistry().findHandler((Operation)operation));
    }

    @Override
    protected void validate(HttpAction action) {
        throw new FusekiException("Call to ServiceRouterServlet.validate");
    }

    @Override
    protected void perform(HttpAction action) {
        throw new FusekiException("Call to ServiceRouterServlet.perform");
    }

    @Override
    protected Operation chooseOperation(HttpAction action, DataService dataService, String endpointName) {
        Endpoint ep = dataService.getEndpoint(endpointName);
        if (ep != null) {
            Operation operation = ep.getOperation();
            action.setEndpoint(ep);
            if (operation != null) {
                if (operation.equals(Operation.GSP_R) || operation.equals(Operation.GSP_RW)) {
                    boolean hasParamGraphDefault;
                    boolean hasParamGraph = action.request.getParameter("graph") != null;
                    boolean bl = hasParamGraphDefault = action.request.getParameter("default") != null;
                    if (!hasParamGraph && !hasParamGraphDefault) {
                        if (operation.equals(Operation.GSP_RW)) {
                            return Operation.Quads_RW;
                        }
                        return Operation.Quads_R;
                    }
                }
                return operation;
            }
            System.err.printf("Notice: endpoint %s but no operation", endpointName);
        }
        ServletOps.errorNotFound("Not found: dataset='" + ServiceRouter.printName(action.getDataAccessPoint().getName()) + "' endpoint='" + ServiceRouter.printName(endpointName) + "'");
        return this.gspOperation(action, action.request);
    }

    @Override
    protected final Operation chooseOperation(HttpAction action, DataService dataService) {
        Operation operation;
        String ct;
        boolean hasParams;
        boolean hasParamGraphDefault;
        boolean isUpdate;
        boolean isQuery;
        HttpServletRequest request = action.getRequest();
        boolean bl = isQuery = request.getParameter("query") != null;
        if (isQuery) {
            if (!this.allowQuery(action)) {
                ServletOps.errorMethodNotAllowed("SPARQL query : " + action.getMethod());
            }
            return Operation.Query;
        }
        boolean bl2 = isUpdate = request.getParameter("update") != null || request.getParameter("request") != null;
        if (isUpdate) {
            if (!this.allowUpdate(action)) {
                ServletOps.errorMethodNotAllowed("SPARQL update : " + action.getMethod());
            }
            return Operation.Update;
        }
        boolean hasParamGraph = request.getParameter("graph") != null;
        boolean bl3 = hasParamGraphDefault = request.getParameter("default") != null;
        if (hasParamGraph || hasParamGraphDefault) {
            return this.gspOperation(action, request);
        }
        boolean bl4 = hasParams = request.getParameterMap().size() > 0;
        if (hasParams) {
            ServletOps.errorBadRequest("Malformed request: unrecognized query string parameters: " + request.getQueryString());
        }
        if ((ct = request.getContentType()) != null && (operation = action.getServiceDispatchRegistry().findOperation(ct)) != null) {
            List<Endpoint> x = action.getDataService().getEndpoints(operation);
            if (x.isEmpty()) {
                ServletOps.errorBadRequest("Malformed request: Content-Type not enabled by an endpoint for this dataset: " + action.getActionURI() + " : Content-Type: " + ct);
            }
            return operation;
        }
        return this.quadsOperation(action, request);
    }

    private Operation gspOperation(HttpAction action, HttpServletRequest request) throws ActionErrorException {
        if (this.isReadMethod(request)) {
            return this.operationGSP_R(action);
        }
        return this.operationGSP_RW(action);
    }

    private Operation quadsOperation(HttpAction action, HttpServletRequest request) throws ActionErrorException {
        if (this.isReadMethod(request)) {
            return this.operationQuads_R(action);
        }
        return this.operationQuads_RW(action);
    }

    private Operation operationGSP_R(HttpAction action) {
        if (this.allowGSP_R(action)) {
            return Operation.GSP_R;
        }
        ServletOps.errorMethodNotAllowed(action.request.getMethod());
        return null;
    }

    private Operation operationGSP_RW(HttpAction action) {
        if (this.allowGSP_RW(action)) {
            return Operation.GSP_RW;
        }
        ServletOps.errorMethodNotAllowed("Read-only dataset : " + action.request.getMethod());
        return null;
    }

    private Operation operationQuads_R(HttpAction action) {
        if (this.allowQuads_R(action)) {
            return Operation.Quads_R;
        }
        ServletOps.errorMethodNotAllowed(action.request.getMethod());
        return null;
    }

    private Operation operationQuads_RW(HttpAction action) {
        if (this.allowQuads_RW(action)) {
            return Operation.Quads_RW;
        }
        ServletOps.errorMethodNotAllowed("Read-only dataset : " + action.request.getMethod());
        return null;
    }

    private boolean isReadMethod(HttpServletRequest request) {
        String method = request.getMethod();
        boolean isGET = method.equals("GET");
        boolean isHEAD = method.equals("HEAD");
        return isGET || isHEAD;
    }

    private static String printName(String x) {
        if (x.startsWith("/")) {
            return x.substring(1);
        }
        return x;
    }

    @Override
    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected boolean allowQuery(HttpAction action) {
        return this.isEnabled(action, Operation.Query);
    }

    protected boolean allowUpdate(HttpAction action) {
        return this.isEnabled(action, Operation.Update);
    }

    protected boolean allowGSP_R(HttpAction action) {
        return this.isEnabled(action, Operation.GSP_R) || this.isEnabled(action, Operation.GSP_RW);
    }

    protected boolean allowGSP_RW(HttpAction action) {
        return this.isEnabled(action, Operation.GSP_RW);
    }

    protected boolean allowQuads_R(HttpAction action) {
        return this.isEnabled(action, Operation.Quads_R) || this.isEnabled(action, Operation.Quads_RW);
    }

    protected boolean allowQuads_RW(HttpAction action) {
        return this.isEnabled(action, Operation.Quads_RW);
    }

    private boolean isEnabled(HttpAction action, Operation operation) {
        DataService dSrv = action.getDataService();
        if (dSrv == null) {
            return false;
        }
        return !dSrv.getEndpoints(operation).isEmpty();
    }
}

