/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.system.Upload;
import org.apache.jena.fuseki.system.UploadDetailsWithName;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class SPARQL_Upload
extends ActionService {
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Upload.setCommonHeadersForOptions(response);
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected void validate(HttpAction action) {
    }

    @Override
    protected void perform(HttpAction action) {
        boolean isMultipart = ServletFileUpload.isMultipartContent(action.request);
        if (!isMultipart) {
            ServletOps.error(400, "Not a file upload");
        }
        long count = SPARQL_Upload.upload(action, "http://server/unset-base/");
        ServletOps.success(action);
        try {
            action.response.setContentType("text/html");
            action.response.setStatus(200);
            PrintWriter out = action.response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            out.println("<p>");
            out.println("Triples = " + count + "\n");
            out.println("<p>");
            out.println("</p>");
            out.println("<button onclick=\"timeFunction()\">Back to Fuseki</button>");
            out.println("</p>");
            out.println("<script type=\"text/javascript\">");
            out.println("function timeFunction(){");
            out.println("window.location.href = \"/fuseki.html\";}");
            out.println("</script>");
            out.println("</body>");
            out.println("</html>");
            out.flush();
            ServletOps.success(action);
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static long upload(HttpAction action, String base) {
        if (action.isTransactional()) {
            return SPARQL_Upload.uploadTxn(action, base);
        }
        return SPARQL_Upload.uploadNonTxn(action, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long uploadNonTxn(HttpAction action, String base) {
        UploadDetailsWithName upload = Upload.multipartUploadWorker(action, base);
        String graphName = upload.graphName;
        DatasetGraph dataTmp = upload.data;
        long count = upload.count;
        if (graphName == null) {
            action.log.info(String.format("[%d] Upload: %d Quads(s)", action.id, count));
        } else {
            action.log.info(String.format("[%d] Upload: Graph: %s, %d triple(s)", action.id, graphName, count));
        }
        Node gn = null;
        if (graphName != null) {
            gn = graphName.equals("default") ? Quad.defaultGraphNodeGenerated : NodeFactory.createURI(graphName);
        }
        action.beginWrite();
        try {
            if (gn != null) {
                FusekiNetLib.addDataInto(dataTmp.getDefaultGraph(), action.getActiveDSG(), gn);
            } else {
                FusekiNetLib.addDataInto(dataTmp, action.getActiveDSG());
            }
            action.commit();
            long l = count;
            return l;
        }
        catch (RuntimeException ex) {
            try {
                action.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServletOps.errorOccurred(ex.getMessage());
            long l = -1L;
            return l;
        }
        finally {
            action.end();
        }
    }

    private static long uploadTxn(HttpAction action, String base) {
        return SPARQL_Upload.uploadNonTxn(action, base);
    }
}

