/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.sparql.core.DatasetDescription;

public abstract class SPARQL_Protocol
extends ActionService {
    private static Predicate<String> acceptNonEmpty = item -> item != null && !item.isEmpty();

    protected SPARQL_Protocol() {
    }

    protected static String messageForQueryException(QueryException ex) {
        if (ex.getMessage() != null) {
            return ex.getMessage();
        }
        if (ex.getCause() != null) {
            return Lib.classShortName(ex.getCause().getClass());
        }
        return null;
    }

    protected static DatasetDescription getProtocolDatasetDescription(HttpAction action) {
        List<String> graphURLs = SPARQL_Protocol.toStrList(action.request.getParameterValues("default-graph-uri"));
        List<String> namedGraphs = SPARQL_Protocol.toStrList(action.request.getParameterValues("named-graph-uri"));
        graphURLs = SPARQL_Protocol.removeEmptyValues(graphURLs);
        namedGraphs = SPARQL_Protocol.removeEmptyValues(namedGraphs);
        if (graphURLs.size() == 0 && namedGraphs.size() == 0) {
            return null;
        }
        return DatasetDescription.create(graphURLs, namedGraphs);
    }

    protected static DatasetDescription getQueryDatasetDescription(Query query2) {
        return DatasetDescription.create(query2);
    }

    protected static DatasetDescription getDatasetDescription(HttpAction action, Query query2) {
        DatasetDescription dsDesc = null;
        if (action != null && (dsDesc = SPARQL_Protocol.getProtocolDatasetDescription(action)) != null) {
            return dsDesc;
        }
        if (query2 != null) {
            dsDesc = SPARQL_Protocol.getQueryDatasetDescription(query2);
        }
        return dsDesc;
    }

    private static List<String> toStrList(String[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    private static List<String> removeEmptyValues(List<String> list) {
        return Iter.iter(list).filter(acceptNonEmpty).toList();
    }

    protected static int countParamOccurences(HttpServletRequest request, String param) {
        String[] x = request.getParameterValues(param);
        if (x == null) {
            return 0;
        }
        return x.length;
    }
}

