/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_GSP;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_R;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.ConNeg;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.system.Upload;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphFactory;

public class SPARQL_GSP_RW
extends SPARQL_GSP_R {
    @Override
    protected void doOptions(HttpAction action) {
        SPARQL_GSP_RW.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS,PUT,DELETE,POST");
        action.response.setHeader("Content-Length", "0");
        ServletOps.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(HttpAction action) {
        action.beginWrite();
        try {
            boolean existedBefore;
            DatasetGraph dsg = this.decideDataset(action);
            SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("DELETE->" + target);
            }
            if (!(existedBefore = target.exists())) {
                action.commit();
                ServletOps.errorNotFound("No such graph: " + target.name);
            }
            this.deleteGraph(action);
            action.commit();
        }
        finally {
            action.end();
        }
        ServletOps.successNoContent(action);
    }

    @Override
    protected void doPut(HttpAction action) {
        this.doPutPost(action, true);
    }

    @Override
    protected void doPost(HttpAction action) {
        this.doPutPost(action, false);
    }

    private void doPutPost(HttpAction action, boolean overwrite) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No Content-Type:");
        }
        if (WebContent.matchContentType(WebContent.ctMultipartMixed, ct)) {
            ServletOps.error(415, "multipart/mixed not supported");
        }
        UploadDetails details = action.isTransactional() ? this.addDataIntoTxn(action, overwrite) : this.addDataIntoNonTxn(action, overwrite);
        MediaType mt = ConNeg.chooseCharset(action.request, DEF.jsonOffer, DEF.acceptJSON);
        if (mt == null) {
            if (details.getExistedBefore().equals((Object)UploadDetails.PreState.ABSENT)) {
                ServletOps.successCreated(action);
            } else {
                ServletOps.successNoContent(action);
            }
            return;
        }
        ServletOps.uploadResponse(action, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadDetails addDataIntoTxn(HttpAction action, boolean overwrite) {
        action.beginWrite();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug(action.request.getMethod().toUpperCase() + "->" + target);
            }
            boolean existedBefore = target.exists();
            Graph g = target.graph();
            if (overwrite && existedBefore) {
                this.clearGraph(target);
            }
            StreamRDF sink = StreamRDFLib.graph(g);
            UploadDetails upload = Upload.incomingData(action, sink);
            upload.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails = upload;
            return uploadDetails;
        }
        catch (ActionErrorException ex) {
            action.abort();
            throw ex;
        }
        catch (RiotException ex) {
            action.abort();
            ServletOps.errorBadRequest(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        catch (Exception ex) {
            action.abort();
            ServletOps.errorOccurred(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadDetails addDataIntoNonTxn(HttpAction action, boolean overwrite) {
        UploadDetails details;
        Graph graphTmp = GraphFactory.createGraphMem();
        StreamRDF dest = StreamRDFLib.graph(graphTmp);
        try {
            details = Upload.incomingData(action, dest);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest(ex.getMessage());
            return null;
        }
        action.beginWrite();
        DatasetGraph dsg = this.decideDataset(action);
        SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(dsg, action);
        boolean existedBefore = false;
        try {
            if (action.log.isDebugEnabled()) {
                action.log.debug("  ->" + target);
            }
            existedBefore = target.exists();
            if (overwrite && existedBefore) {
                this.clearGraph(target);
            }
            FusekiNetLib.addDataInto(graphTmp, target.dsg, target.graphName);
            details.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails = details;
            return uploadDetails;
        }
        catch (Exception ex) {
            try {
                action.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServletOps.errorOccurred(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.end();
        }
    }

    protected void deleteGraph(HttpAction action) {
        DatasetGraph dsg = this.decideDataset(action);
        SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(dsg, action);
        if (target.isDefault) {
            this.clearGraph(target);
        } else {
            action.getActiveDSG().removeGraph(target.graphName);
        }
    }

    protected void clearGraph(SPARQL_GSP.Target target) {
        Graph g = target.graph();
        g.getPrefixMapping().clearNsPrefixMap();
        g.clear();
    }
}

