/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.atlas.web.TypedOutputStream;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_GSP;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;

public class SPARQL_GSP_R
extends SPARQL_GSP {
    @Override
    protected String mapRequestToDataset(HttpAction action) {
        return ActionLib.mapRequestToDatasetLongest$(action.request.getRequestURI(), action.getDataAccessPointRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpAction action) {
        ServletOutputStream output;
        MediaType mediaType = ActionLib.contentNegotationRDF(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream(output, mediaType);
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentType());
        if (action.verbose) {
            action.log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        action.beginRead();
        SPARQL_GSP_R.setCommonHeaders(action.response);
        try {
            boolean exists;
            DatasetGraph dsg = this.decideDataset(action);
            SPARQL_GSP.Target target = SPARQL_GSP_R.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("GET->" + target);
            }
            if (!(exists = target.exists())) {
                ServletOps.errorNotFound("No such graph: <" + target.name + ">");
            }
            Graph g = target.graph();
            if (!target.isDefault && g.isEmpty()) {
                ServletOps.errorNotFound("No such graph: <" + target.name + ">");
            }
            String ct = lang.getContentType().toHeaderString();
            action.response.setContentType(ct);
            RDFFormat fmt = lang == Lang.RDFXML ? RDFFormat.RDFXML_PLAIN : RDFWriterRegistry.defaultSerialization(lang);
            try {
                RDFDataMgr.write((OutputStream)out, g, fmt);
            }
            catch (JenaException ex) {
                if (fmt.getLang().equals(Lang.RDFXML)) {
                    ServletOps.errorBadRequest("Failed to write output in RDF/XML: " + ex.getMessage());
                }
                ServletOps.errorOccurred("Failed to write output: " + ex.getMessage(), ex);
            }
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(HttpAction action) {
        SPARQL_GSP_R.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS");
        action.response.setHeader("Content-Length", "0");
        ServletOps.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHead(HttpAction action) {
        action.beginRead();
        SPARQL_GSP_R.setCommonHeaders(action.response);
        try {
            DatasetGraph dsg = this.decideDataset(action);
            SPARQL_GSP.Target target = SPARQL_GSP_R.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("HEAD->" + target);
            }
            if (!target.exists()) {
                ServletOps.successNotFound(action);
                return;
            }
            MediaType mediaType = ActionLib.contentNegotationRDF(action);
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        ServletOps.errorMethodNotAllowed("POST : Read-only");
    }

    @Override
    protected void doDelete(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE : Read-only");
    }

    @Override
    protected void doPut(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PUT : Read-only");
    }

    @Override
    protected void doPatch(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PATCH : Read-only");
    }
}

