/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.ResultSetFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseJson {
    private static Logger xlog = LoggerFactory.getLogger(ResponseJson.class);

    public static void doResponseJson(HttpAction action, Iterator<JsonObject> jsonItem) {
        if (jsonItem == null) {
            xlog.warn("doResponseJson: Result set is null");
            throw new FusekiException("Result set is null");
        }
        ResponseJson.jsonOutput(action, jsonItem);
    }

    private static void jsonOutput(HttpAction action, final Iterator<JsonObject> jsonItems) {
        ResponseResultSet.OutputContent proc = new ResponseResultSet.OutputContent(){

            @Override
            public void output(ServletOutputStream out) {
                if (jsonItems != null) {
                    ResultSetFormatter.output(out, jsonItems);
                }
            }
        };
        try {
            String callback = ResponseOps.paramCallback(action.request);
            ServletOutputStream out = action.response.getOutputStream();
            if (callback != null) {
                callback = StringUtils.replaceChars(callback, "\r", "");
                callback = StringUtils.replaceChars(callback, "\n", "");
                out.print(callback);
                out.println("(");
            }
            ResponseJson.output(action, "application/json", "utf-8", proc);
            if (callback != null) {
                out.println(")");
            }
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    private static void output(HttpAction action, String contentType, String charset, ResponseResultSet.OutputContent proc) {
        try {
            ResponseJson.setHttpResponse(action.request, action.response, contentType, charset);
            action.response.setStatus(200);
            ServletOutputStream out = action.response.getOutputStream();
            try {
                proc.output(out);
                out.flush();
            }
            catch (QueryCancelledException ex) {
                xlog.info(String.format("[%d] Query Cancelled - results truncated (but 200 already sent)", action.id));
                out.println();
                out.println("##  Query cancelled due to timeout during execution   ##");
                out.println("##  ****          Incomplete results           ****   ##");
                out.flush();
            }
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static void setHttpResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String contentType, String charset) {
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Pragma", "no-cache");
        if (contentType != null) {
            if (charset != null) {
                contentType = contentType + "; charset=" + charset;
            }
            xlog.trace("Content-Type for response: " + contentType);
            httpResponse.setContentType(contentType);
        }
    }
}

