/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.sparql.core.DatasetGraph;

public abstract class ActionREST
extends ActionService {
    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void perform(HttpAction action) {
        this.dispatch(action);
    }

    private void dispatch(HttpAction action) {
        HttpServletRequest req = action.request;
        HttpServletResponseTracker resp = action.response;
        String method = req.getMethod().toUpperCase(Locale.ROOT);
        if (method.equals("GET")) {
            this.doGet$(action);
        } else if (method.equals("HEAD")) {
            this.doHead$(action);
        } else if (method.equals("POST")) {
            this.doPost$(action);
        } else if (method.equals("PATCH")) {
            this.doPatch$(action);
        } else if (method.equals("OPTIONS")) {
            this.doOptions$(action);
        } else if (method.equals("TRACE")) {
            ServletOps.errorMethodNotAllowed("TRACE");
        } else if (method.equals("PUT")) {
            this.doPut$(action);
        } else if (method.equals("DELETE")) {
            this.doDelete$(action);
        } else {
            ServletOps.errorNotImplemented("Unknown method: " + method);
        }
    }

    protected DatasetGraph decideDataset(HttpAction action) {
        return action.getActiveDSG();
    }

    private final void doGet$(HttpAction action) {
        ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPget);
        try {
            this.doGet(action);
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPgetGood);
        }
        catch (ActionErrorException ex) {
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPgetBad);
            throw ex;
        }
    }

    private final void doHead$(HttpAction action) {
        ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPhead);
        try {
            this.doHead(action);
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPheadGood);
        }
        catch (ActionErrorException ex) {
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPheadBad);
            throw ex;
        }
    }

    private final void doPost$(HttpAction action) {
        ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPpost);
        try {
            this.doPost(action);
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPpostGood);
        }
        catch (ActionErrorException ex) {
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPpostBad);
            throw ex;
        }
    }

    private final void doPatch$(HttpAction action) {
        ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPpatch);
        try {
            this.doPatch(action);
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPpatchGood);
        }
        catch (ActionErrorException ex) {
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPpatchBad);
            throw ex;
        }
    }

    private final void doDelete$(HttpAction action) {
        ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPdelete);
        try {
            this.doDelete(action);
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPdeleteGood);
        }
        catch (ActionErrorException ex) {
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPdeleteBad);
            throw ex;
        }
    }

    private final void doPut$(HttpAction action) {
        ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPput);
        try {
            this.doPut(action);
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPputGood);
        }
        catch (ActionErrorException ex) {
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPputBad);
            throw ex;
        }
    }

    private final void doOptions$(HttpAction action) {
        ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPoptions);
        try {
            this.doOptions(action);
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPoptionsGood);
        }
        catch (ActionErrorException ex) {
            ActionREST.incCounter(action.getEndpoint(), CounterName.HTTPoptionsBad);
            throw ex;
        }
    }

    protected abstract void doGet(HttpAction var1);

    protected abstract void doHead(HttpAction var1);

    protected abstract void doPost(HttpAction var1);

    protected abstract void doPatch(HttpAction var1);

    protected abstract void doDelete(HttpAction var1);

    protected abstract void doPut(HttpAction var1);

    protected abstract void doOptions(HttpAction var1);
}

