/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import org.apache.jena.fuseki.server.NameMgr;

public class Operation {
    private static NameMgr<Operation> mgr = new NameMgr();
    public static final Operation Query = Operation.register("Query", "SPARQL Query");
    public static final Operation Update = Operation.register("Update", "SPARQL Update");
    public static final Operation Upload = Operation.register("Upload", "File Upload");
    public static final Operation GSP_R = Operation.register("GSP_R", "Graph Store Protocol (Read)");
    public static final Operation GSP_RW = Operation.register("GSP_RW", "Graph Store Protocol");
    public static final Operation Quads_R = Operation.register("Quads_R", "HTTP Quads (Read)");
    public static final Operation Quads_RW = Operation.register("Quads_RW", "HTTP Quads");
    public static final Operation DatasetRequest_R = Quads_R;
    public static final Operation DatasetRequest_RW = Quads_RW;
    private final String description;
    private final String name;

    public static Operation register(String name, String description) {
        return mgr.register(name, x -> Operation.create(x, description));
    }

    private static Operation create(String name, String description) {
        return new Operation(name, description);
    }

    private Operation(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation other = (Operation)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

