/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.ListMultimap;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataServiceStatus;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.query.TxnType;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.sys.TDBInternal;

public class DataService {
    private DatasetGraph dataset;
    private ListMultimap<Operation, Endpoint> operations = ArrayListMultimap.create();
    private Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private AuthPolicy authPolicy = null;
    private List<DataAccessPoint> dataAccessPoints = new ArrayList<DataAccessPoint>(1);
    private volatile DataServiceStatus state = DataServiceStatus.UNINITIALIZED;
    private final CounterSet counters = new CounterSet();
    private final AtomicBoolean offlineInProgress = new AtomicBoolean(false);
    private final AtomicBoolean acceptingRequests = new AtomicBoolean(true);
    public AtomicLong activeTxn = new AtomicLong(0L);
    public AtomicLong totalTxn = new AtomicLong(0L);

    public DataService(DatasetGraph dataset) {
        this.dataset = dataset;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
        this.goActive();
    }

    private DataService(int dummy, DataService other) {
        this.dataset = other.dataset;
        this.operations = ArrayListMultimap.create(other.operations);
        this.endpoints = new HashMap<String, Endpoint>(other.endpoints);
        this.state = DataServiceStatus.UNINITIALIZED;
    }

    void noteDataAccessPoint(DataAccessPoint dap) {
        this.dataAccessPoints.add(dap);
    }

    private String label() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        this.dataAccessPoints.stream().map(DataAccessPoint::getName).filter(x -> !x.isEmpty()).forEach(sj::add);
        return sj.toString();
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public void addEndpoint(Operation operation, String endpointName) {
        this.addEndpoint(operation, endpointName, null);
    }

    public void addEndpoint(Operation operation, String endpointName, AuthPolicy authPolicy) {
        Endpoint endpoint = new Endpoint(operation, endpointName, authPolicy);
        this.endpoints.put(endpointName, endpoint);
        this.operations.put(operation, endpoint);
    }

    public Endpoint getEndpoint(String endpointName) {
        return this.endpoints.get(endpointName);
    }

    public Collection<Endpoint> getEndpoints() {
        return this.operations.values();
    }

    public List<Endpoint> getEndpoints(Operation operation) {
        List<Endpoint> x = this.operations.get((Object)operation);
        if (x == null) {
            x = Collections.emptyList();
        }
        return x;
    }

    public Collection<Operation> getOperations() {
        return this.operations.keySet();
    }

    public boolean allowUpdate() {
        return true;
    }

    public void goOffline() {
        this.offlineInProgress.set(true);
        this.acceptingRequests.set(false);
        this.state = DataServiceStatus.OFFLINE;
    }

    public void goActive() {
        this.offlineInProgress.set(false);
        this.acceptingRequests.set(true);
        this.state = DataServiceStatus.ACTIVE;
    }

    public boolean isAcceptingRequests() {
        return this.acceptingRequests.get();
    }

    public CounterSet getCounters() {
        return this.counters;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }

    public void startTxn(TxnType mode) {
        this.check(DataServiceStatus.ACTIVE);
        this.activeTxn.getAndIncrement();
        this.totalTxn.getAndIncrement();
    }

    private void check(DataServiceStatus status) {
        if (this.state != status) {
            String msg = String.format("DataService %s: Expected=%s, Actual=%s", new Object[]{this.label(), status, this.state});
            throw new FusekiException(msg);
        }
    }

    public void finishTxn() {
        this.activeTxn.decrementAndGet();
    }

    public synchronized void shutdown() {
        if (this.state == DataServiceStatus.CLOSING) {
            return;
        }
        Fuseki.serverLog.info(String.format("Shutting down data service for %s", this.endpoints.keySet()));
        this.expel(this.dataset);
        this.dataset = null;
        this.state = DataServiceStatus.CLOSED;
    }

    private void expel(DatasetGraph database) {
        if (database instanceof DatasetGraphText) {
            DatasetGraphText dbtext = (DatasetGraphText)database;
            database = dbtext.getBase();
            dbtext.getTextIndex().close();
        }
        boolean isTDB1 = org.apache.jena.tdb.sys.TDBInternal.isTDB1(database);
        boolean isTDB2 = TDBInternal.isTDB2(database);
        if (isTDB1 || isTDB2) {
            if (isTDB1) {
                org.apache.jena.tdb.sys.TDBInternal.expel(database);
            }
            if (isTDB2) {
                TDBInternal.expel(database);
            }
        } else {
            this.dataset.close();
        }
    }

    public void setAuthPolicy(AuthPolicy authPolicy) {
        this.authPolicy = authPolicy;
    }

    public AuthPolicy authPolicy() {
        return this.authPolicy;
    }
}

