/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.HttpAction;

public class DataAccessPoint {
    private final String name;
    private final DataService dataService;
    private AtomicLong requests = new AtomicLong(0L);

    public DataAccessPoint(String name, DataService dataService) {
        this.name = DataAccessPoint.canonical(name);
        this.dataService = dataService;
        dataService.noteDataAccessPoint(this);
    }

    public String getName() {
        return this.name;
    }

    public static String canonical(String datasetPath) {
        if (datasetPath == null) {
            return datasetPath;
        }
        if (datasetPath.equals("/")) {
            datasetPath = "";
        } else if (!datasetPath.startsWith("/")) {
            datasetPath = "/" + datasetPath;
        }
        if (datasetPath.endsWith("/")) {
            datasetPath = datasetPath.substring(0, datasetPath.length() - 1);
        }
        return datasetPath;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public long requestCount() {
        return this.requests.get();
    }

    public void startRequest(HttpAction httpAction) {
        this.requests.incrementAndGet();
    }

    public void finishRequest(HttpAction httpAction) {
        this.requests.getAndDecrement();
    }
}

