/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.metrics.prometheus;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.DiskSpaceMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.File;
import javax.servlet.ServletOutputStream;
import org.apache.jena.fuseki.metrics.MetricsProvider;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class PrometheusMetricsProvider
implements MetricsProvider {
    private PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);

    public PrometheusMetricsProvider() {
        this.meterRegistry.config().commonTags("application", "fuseki");
        new FileDescriptorMetrics().bindTo(this.meterRegistry);
        new ProcessorMetrics().bindTo(this.meterRegistry);
        new ClassLoaderMetrics().bindTo(this.meterRegistry);
        new UptimeMetrics().bindTo(this.meterRegistry);
        for (File root2 : File.listRoots()) {
            new DiskSpaceMetrics(root2).bindTo(this.meterRegistry);
        }
        new JvmGcMetrics().bindTo(this.meterRegistry);
        new JvmMemoryMetrics().bindTo(this.meterRegistry);
        new JvmThreadMetrics().bindTo(this.meterRegistry);
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public void scrape(HttpAction action) {
        try (ServletOutputStream out = action.response.getOutputStream();){
            ServletOps.success(action);
            action.response.setContentType("text/plain");
            action.response.setCharacterEncoding("utf-8");
            out.write(this.meterRegistry.scrape().getBytes());
        }
        catch (Throwable t) {
            ServletOps.errorOccurred(t);
        }
    }
}

