/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import java.util.List;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;

public class JsonDescription {
    public static void arrayDatasets(JsonBuilder builder, DataAccessPointRegistry registry) {
        builder.startArray();
        for (String ds : registry.keys()) {
            DataAccessPoint access = (DataAccessPoint)registry.get(ds);
            JsonDescription.describe(builder, access);
        }
        builder.finishArray();
    }

    public static void describe(JsonBuilder builder, DataAccessPoint access) {
        builder.startObject();
        builder.key("ds.name").value(access.getName());
        builder.key("ds.state").value(access.getDataService().isAcceptingRequests());
        builder.key("ds.services");
        builder.startArray();
        for (Operation operation : access.getDataService().getOperations()) {
            List<Endpoint> endpoints = access.getDataService().getEndpoints(operation);
            JsonDescription.describe(builder, operation, endpoints);
        }
        builder.finishArray();
        builder.finishObject();
    }

    private static void describe(JsonBuilder builder, Operation operation, List<Endpoint> endpoints) {
        builder.startObject();
        builder.key("srv.type").value(operation.getName());
        builder.key("srv.description").value(operation.getDescription());
        builder.key("srv.endpoints");
        builder.startArray();
        for (Endpoint endpoint : endpoints) {
            builder.value(endpoint.getName());
        }
        builder.finishArray();
        builder.finishObject();
    }
}

