/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.async.AsyncPool;
import org.apache.jena.fuseki.async.AsyncTask;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.HttpAction;

public class Async {
    public static AsyncTask asyncTask(AsyncPool asyncPool, String displayName, DataService dataService, Runnable task, long requestId) {
        AsyncTask asyncTask = asyncPool.submit(task, displayName, dataService, requestId);
        return asyncTask;
    }

    public static JsonValue asJson(AsyncTask asyncTask) {
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("outer");
        builder.key("taskId").value(asyncTask.getTaskId());
        if (asyncTask.getOriginatingRequestId() > 0L) {
            builder.key("requestId").value(asyncTask.getOriginatingRequestId());
        }
        builder.finishObject("outer");
        return builder.build();
    }

    public static void setLocationHeader(HttpAction action, AsyncTask asyncTask) {
        String x = action.getRequest().getRequestURI();
        if (!x.endsWith("/")) {
            x = x + "/";
        }
        x = x + asyncTask.getTaskId();
        action.getResponse().setHeader("Location", x);
    }

    public static AsyncTask execASyncTask(HttpAction action, AsyncPool asyncPool, String displayName, Runnable runnable) {
        AsyncTask atask = Async.asyncTask(asyncPool, displayName, action.getDataService(), runnable, action.id);
        Async.setLocationHeader(action, atask);
        return atask;
    }
}

