/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.build.DatasetDescriptionRegistry;
import org.apache.jena.fuseki.build.FusekiBuildLib;
import org.apache.jena.fuseki.build.FusekiBuilder;
import org.apache.jena.fuseki.build.FusekiConst;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.DataServiceStatus;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;

public class FusekiConfig {
    private static Logger log;

    public static List<DataAccessPoint> processServerConfiguration(Model configuration, Context context) {
        Resource server = FusekiConfig.findServer(configuration);
        FusekiConfig.processContext(server, context);
        FusekiConfig.processLoadClass(server);
        List<DataAccessPoint> x = FusekiConfig.servicesAndDatasets(configuration);
        return x;
    }

    public static List<DataAccessPoint> processServerConfiguration(Resource server, Context context) {
        Objects.requireNonNull(server);
        FusekiConfig.processContext(server, context);
        FusekiConfig.processLoadClass(server);
        List<DataAccessPoint> x = FusekiConfig.servicesAndDatasets(server);
        return x;
    }

    public static Resource findServer(Model model) {
        List<Resource> servers = GraphUtils.listResourcesByType(model, FusekiVocab.tServer);
        if (servers.size() == 0) {
            return null;
        }
        if (servers.size() > 1) {
            throw new FusekiConfigException(servers.size() + " servers found (must be exactly one in a configuration file)");
        }
        Resource server = servers.get(0);
        return server;
    }

    public static void processContext(Resource server, Context cxt) {
        if (server == null) {
            return;
        }
        AssemblerUtils.setContext(server, cxt);
    }

    public static void processLoadClass(Resource server) {
        if (server == null) {
            return;
        }
        StmtIterator sIter = server.listProperties(JA.loadClass);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            RDFNode rn = s.getObject();
            String className = null;
            if (rn instanceof Resource) {
                String uri = ((Resource)rn).getURI();
                if (uri == null) {
                    log.warn("Blank node for class to load");
                    continue;
                }
                String javaScheme = "java:";
                if (!uri.startsWith(javaScheme)) {
                    log.warn("Class to load is not 'java:': " + uri);
                    continue;
                }
                className = uri.substring(javaScheme.length());
            }
            if (rn instanceof Literal) {
                className = ((Literal)rn).getLexicalForm();
            }
            FusekiConfig.loadAndInit(className);
        }
    }

    public static List<DataAccessPoint> servicesAndDatasets(Model model) {
        Resource server = FusekiConfig.findServer(model);
        return FusekiConfig.servicesAndDatasets$(server, model);
    }

    public static List<DataAccessPoint> servicesAndDatasets(Resource server) {
        Objects.requireNonNull(server);
        return FusekiConfig.servicesAndDatasets$(server, server.getModel());
    }

    private static List<DataAccessPoint> servicesAndDatasets$(Resource server, Model model) {
        DatasetDescriptionRegistry dsDescMap = new DatasetDescriptionRegistry();
        ResultSet rs = FusekiBuildLib.query("SELECT * { ?s fu:services [ list:member ?service ] }", model, "s", (RDFNode)server);
        ArrayList<DataAccessPoint> accessPoints = new ArrayList<DataAccessPoint>();
        if (!rs.hasNext()) {
            rs = FusekiBuildLib.query("SELECT ?service { ?service a fu:Service }", model);
        }
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            Resource svc = soln.getResource("service");
            DataAccessPoint acc = FusekiConfig.buildDataAccessPoint(svc, dsDescMap);
            accessPoints.add(acc);
        }
        return accessPoints;
    }

    private static void loadAndInit(String className) {
        try {
            Class<?> classObj = Class.forName(className);
            log.info("Loaded " + className);
            Method initMethod = classObj.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            log.warn("Class not found: " + className);
        }
        catch (Exception e2) {
            throw new FusekiConfigException(e2);
        }
    }

    private static Model readAssemblerFile(String filename) {
        return AssemblerUtils.readAssemblerFile(filename);
    }

    public static List<DataAccessPoint> readConfigurationDirectory(String dir) {
        Path pDir = Paths.get(dir, new String[0]).normalize();
        File dirFile = pDir.toFile();
        if (!dirFile.exists()) {
            log.warn("Not found: directory for assembler files for services: '" + dir + "'");
            return Collections.emptyList();
        }
        if (!dirFile.isDirectory()) {
            log.warn("Not a directory: '" + dir + "'");
            return Collections.emptyList();
        }
        DirectoryStream.Filter<Path> filter = entry -> {
            File f = entry.toFile();
            Lang lang = RDFLanguages.filenameToLang(f.getName());
            return !f.isHidden() && f.isFile() && lang != null && RDFParserRegistry.isRegistered(lang);
        };
        ArrayList<DataAccessPoint> dataServiceRef = new ArrayList<DataAccessPoint>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pDir, filter);){
            for (Path p : stream) {
                DatasetDescriptionRegistry dsDescMap = new DatasetDescriptionRegistry();
                String fn = IRILib.filenameToIRI(p.toString());
                log.info("Load configuration: " + fn);
                Model m = FusekiConfig.readAssemblerFile(fn);
                FusekiConfig.readConfiguration(m, dsDescMap, dataServiceRef);
            }
        }
        catch (IOException ex) {
            log.warn("IOException:" + ex.getMessage(), ex);
        }
        return dataServiceRef;
    }

    private static void readConfiguration(Model m, DatasetDescriptionRegistry dsDescMap, List<DataAccessPoint> dataServiceRef) {
        List<Resource> services = GraphUtils.listResourcesByType(m, FusekiVocab.fusekiService);
        if (services.size() == 0) {
            log.error("No services found");
            throw new FusekiConfigException();
        }
        for (Resource service : services) {
            DataAccessPoint acc = FusekiConfig.buildDataAccessPoint(service, dsDescMap);
            dataServiceRef.add(acc);
        }
    }

    public static DataAccessPoint buildDataAccessPoint(Resource svc, DatasetDescriptionRegistry dsDescMap) {
        RDFNode n = FusekiBuildLib.getOne(svc, "fu:name");
        if (!n.isLiteral()) {
            throw new FusekiConfigException("Not a literal for access point name: " + FmtUtils.stringForRDFNode(n));
        }
        Literal object = n.asLiteral();
        if (object.getDatatype() != null && !object.getDatatype().equals(XSDDatatype.XSDstring)) {
            Fuseki.configLog.error(String.format("Service name '%s' is not a string", FmtUtils.stringForRDFNode(object)));
        }
        String name = object.getLexicalForm();
        name = DataAccessPoint.canonical(name);
        DataService dataService = FusekiConfig.buildDataService(svc, dsDescMap);
        AuthPolicy allowedUsers = FusekiBuilder.allowedUsers(svc);
        dataService.setAuthPolicy(allowedUsers);
        DataAccessPoint dataAccess = new DataAccessPoint(name, dataService);
        return dataAccess;
    }

    private static DataService buildDataService(Resource svc, DatasetDescriptionRegistry dsDescMap) {
        Resource datasetDesc = (Resource)FusekiBuildLib.getOne(svc, "fu:dataset");
        Dataset ds = FusekiConfig.getDataset(datasetDesc, dsDescMap);
        DataService dataService = new DataService(ds.asDatasetGraph());
        FusekiBuilder.addServiceEP(dataService, Operation.Query, svc, FusekiVocab.pServiceQueryEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Update, svc, FusekiVocab.pServiceUpdateEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Upload, svc, FusekiVocab.pServiceUploadEP);
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_R, svc, FusekiVocab.pServiceReadGraphStoreEP);
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_RW, svc, FusekiVocab.pServiceReadWriteGraphStoreEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Quads_R, svc, FusekiVocab.pServiceReadQuadsEP);
        FusekiBuilder.addServiceEP(dataService, Operation.Quads_RW, svc, FusekiVocab.pServiceReadWriteQuadsEP);
        if (!dataService.getEndpoints(Operation.GSP_RW).isEmpty() || !dataService.getEndpoints(Operation.Quads_RW).isEmpty()) {
            dataService.addEndpoint(Operation.DatasetRequest_RW, "");
        } else if (!dataService.getEndpoints(Operation.GSP_R).isEmpty() || !dataService.getEndpoints(Operation.Quads_R).isEmpty()) {
            dataService.addEndpoint(Operation.DatasetRequest_R, "");
        }
        return dataService;
    }

    public static Dataset getDataset(Resource datasetDesc, DatasetDescriptionRegistry dsDescMap) {
        Dataset ds = dsDescMap.get(datasetDesc);
        if (ds == null) {
            if (!datasetDesc.hasProperty(RDF.type)) {
                throw new FusekiConfigException("No rdf:type for dataset " + FusekiBuildLib.nodeLabel(datasetDesc));
            }
            ds = (Dataset)Assembler.general.open(datasetDesc);
        }
        dsDescMap.register(datasetDesc, ds);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DataAccessPoint> readSystemDatabase(Dataset ds) {
        DatasetDescriptionRegistry dsDescMap = new DatasetDescriptionRegistry();
        String qs = StrUtils.strjoinNL(FusekiConst.PREFIXES, "SELECT * {", "  GRAPH ?g {", "     ?s fu:name ?name ;", "        fu:status ?status .", "  }", "}");
        ArrayList<DataAccessPoint> refs = new ArrayList<DataAccessPoint>();
        ds.begin(ReadWrite.WRITE);
        try {
            ResultSet rs = FusekiBuildLib.query(qs, ds);
            while (rs.hasNext()) {
                QuerySolution row = rs.next();
                Resource s = row.getResource("s");
                Resource g = row.getResource("g");
                Resource rStatus = row.getResource("status");
                DataServiceStatus status = DataServiceStatus.status(rStatus);
                Model m = ds.getNamedModel(g.getURI());
                Resource svc = m.wrapAsResource(s.asNode());
                DataAccessPoint ref = FusekiConfig.buildDataAccessPoint(svc, dsDescMap);
                refs.add(ref);
            }
            ds.commit();
            ArrayList<DataAccessPoint> arrayList = refs;
            return arrayList;
        }
        finally {
            ds.end();
        }
    }

    static {
        Fuseki.init();
        log = Fuseki.configLog;
    }
}

