/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.build.FusekiBuildLib;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class FusekiBuilder {
    public static DataService buildDataServiceStd(DatasetGraph dsg, boolean allowUpdate) {
        DataService dataService = new DataService(dsg);
        FusekiBuilder.populateStdServices(dataService, allowUpdate);
        return dataService;
    }

    public static void populateStdServices(DataService dataService, boolean allowUpdate) {
        FusekiBuilder.addServiceEP(dataService, Operation.Query, "query");
        FusekiBuilder.addServiceEP(dataService, Operation.Query, "sparql");
        if (!allowUpdate) {
            FusekiBuilder.addServiceEP(dataService, Operation.GSP_R, "data");
            FusekiBuilder.addServiceEP(dataService, Operation.DatasetRequest_R, "");
            return;
        }
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_RW, "data");
        FusekiBuilder.addServiceEP(dataService, Operation.GSP_R, "get");
        FusekiBuilder.addServiceEP(dataService, Operation.Update, "update");
        FusekiBuilder.addServiceEP(dataService, Operation.Upload, "upload");
        FusekiBuilder.addServiceEP(dataService, Operation.DatasetRequest_RW, "");
    }

    public static void addServiceEP(DataService dataService, Operation operation, String endpointName) {
        dataService.addEndpoint(operation, endpointName);
    }

    public static void addServiceEP(DataService dataService, Operation operation, String endpointName, AuthPolicy requestAuth) {
        dataService.addEndpoint(operation, endpointName, requestAuth);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addServiceEP(DataService dataService, Operation operation, Resource svc, Property property) {
        String p = "<" + property.getURI() + ">";
        ResultSet rs = FusekiBuildLib.query("SELECT * { ?svc " + p + " ?ep}", svc.getModel(), "svc", (RDFNode)svc);
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            AuthPolicy requestAuth = null;
            RDFNode ep = soln.get("ep");
            String epName = null;
            if (ep.isLiteral()) {
                epName = soln.getLiteral("ep").getLexicalForm();
            } else {
                if (!ep.isResource()) throw new FusekiConfigException("Unrecognized: " + ep);
                Resource r = (Resource)ep;
                try {
                    epName = r.getProperty(FusekiVocab.pServiceName).getString();
                    List<RDFNode> x = GraphUtils.multiValue(r, FusekiVocab.pAllowedUsers);
                    if (x.size() > 1) {
                        throw new FusekiConfigException("Multiple fuseki:" + FusekiVocab.pAllowedUsers.getLocalName() + " for " + r);
                    }
                    if (!x.isEmpty()) {
                        requestAuth = FusekiBuilder.allowedUsers(r);
                    }
                }
                catch (ClassCastException | JenaException ex) {
                    throw new FusekiConfigException("Failed to parse endpoint: " + r);
                }
            }
            FusekiBuilder.addServiceEP(dataService, operation, epName, requestAuth);
        }
    }

    public static void addDataService(DataAccessPointRegistry dataAccessPoints, String name, DataService dataService) {
        if (dataAccessPoints.isRegistered(name = DataAccessPoint.canonical(name))) {
            throw new FusekiConfigException("Data service name already registered: " + name);
        }
        DataAccessPoint dap = new DataAccessPoint(name, dataService);
        dataAccessPoints.register(dap);
    }

    public static void addDataset(DataAccessPointRegistry dataAccessPoints, String name, DatasetGraph dsg, boolean withUpdate) {
        if (dataAccessPoints.isRegistered(name = DataAccessPoint.canonical(name))) {
            throw new FusekiConfigException("Data service name already registered: " + name);
        }
        DataAccessPoint dap = FusekiBuilder.buildDataAccessPoint(name, dsg, withUpdate);
        dataAccessPoints.register(dap);
    }

    private static DataAccessPoint buildDataAccessPoint(String name, DatasetGraph dsg, boolean withUpdate) {
        DataService dataService = FusekiBuilder.buildDataServiceStd(dsg, withUpdate);
        DataAccessPoint dap = new DataAccessPoint(name, dataService);
        return dap;
    }

    public static void removeDataset(DataAccessPointRegistry dataAccessPoints, String name) {
        name = DataAccessPoint.canonical(name);
        dataAccessPoints.remove(name);
    }

    public static AuthPolicy allowedUsers(Resource resource) {
        if (resource == null) {
            return null;
        }
        Collection<RDFNode> allowedUsers = FusekiBuildLib.getAll(resource, "fu:" + FusekiVocab.pAllowedUsers.getLocalName());
        if (allowedUsers == null) {
            return null;
        }
        List bad = allowedUsers.stream().map(FrontsNode::asNode).filter(rn -> !Util.isSimpleString(rn)).map(rn -> rn.toString()).collect(Collectors.toList());
        if (!bad.isEmpty()) {
            throw new FusekiConfigException(String.format("User names should be a simple string: bad = %s", bad));
        }
        Collection userNames = allowedUsers.stream().map(FrontsNode::asNode).map(Node::getLiteralLexicalForm).collect(Collectors.toList());
        return Auth.policyAllowSpecific(userNames);
    }
}

