/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.FusekiConst;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDFS;

public class FusekiBuildLib {
    public static ResultSet query(String string, Model m) {
        return FusekiBuildLib.query(string, m, null, null);
    }

    public static RDFNode queryOne(String string, Model m, String varname) {
        ResultSet rs = FusekiBuildLib.query(string, m);
        return FusekiBuildLib.getExactlyOne(rs, varname);
    }

    private static RDFNode getExactlyOne(ResultSet rs, String varname) {
        if (!rs.hasNext()) {
            return null;
        }
        QuerySolution qs = rs.next();
        if (rs.hasNext()) {
            return null;
        }
        return qs.get(varname);
    }

    public static ResultSet query(String string, Dataset ds) {
        return FusekiBuildLib.query(string, ds, null, null);
    }

    public static ResultSet query(String string, Model m, String varName, RDFNode value) {
        Query query2 = QueryFactory.create(FusekiConst.PREFIXES + string);
        QuerySolutionMap initValues = null;
        if (varName != null && value != null) {
            initValues = FusekiBuildLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, m, initValues);){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults(qExec.execSelect());
            return resultSetRewindable;
        }
    }

    public static ResultSet query(String string, Dataset ds, String varName, RDFNode value) {
        Query query2 = QueryFactory.create(FusekiConst.PREFIXES + string);
        QuerySolutionMap initValues = null;
        if (varName != null && value != null) {
            initValues = FusekiBuildLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecutionFactory.create(query2, ds, initValues);){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults(qExec.execSelect());
            return resultSetRewindable;
        }
    }

    private static QuerySolutionMap querySolution(String varName, RDFNode value) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        FusekiBuildLib.querySolution(qsm, varName, value);
        return qsm;
    }

    public static QuerySolutionMap querySolution(QuerySolutionMap qsm, String varName, RDFNode value) {
        qsm.add(varName, value);
        return qsm;
    }

    public static RDFNode getOne(Resource svc, String property) {
        ResultSet rs = FusekiBuildLib.query("SELECT * { ?svc " + property + " ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            throw new FusekiConfigException("No property '" + property + "' for service " + FusekiBuildLib.nodeLabel(svc));
        }
        RDFNode x = rs.next().get("x");
        if (rs.hasNext()) {
            throw new FusekiConfigException("Multiple properties '" + property + "' for service " + FusekiBuildLib.nodeLabel(svc));
        }
        return x;
    }

    public static Collection<RDFNode> getAll(Resource svc, String property) {
        ResultSet rs = FusekiBuildLib.query("SELECT * { ?svc " + property + " ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            return null;
        }
        ArrayList<RDFNode> results = new ArrayList<RDFNode>();
        rs.forEachRemaining(qs -> {
            RDFNode n = qs.get("x");
            try {
                RDFList list = n.as(RDFList.class);
                results.addAll(list.asJavaList());
            }
            catch (JenaException x) {
                results.add(n);
            }
        });
        return results;
    }

    public static String nodeLabel(RDFNode n) {
        if (n == null) {
            return "<null>";
        }
        if (n instanceof Resource) {
            return FusekiBuildLib.strForResource((Resource)n);
        }
        Literal lit = (Literal)n;
        return lit.getLexicalForm();
    }

    public static String strForResource(Resource r) {
        return FusekiBuildLib.strForResource(r, r.getModel());
    }

    public static String strForResource(Resource r, PrefixMapping pm) {
        RDFNode n;
        if (r == null) {
            return "NULL ";
        }
        if (r.hasProperty(RDFS.label) && (n = r.getProperty(RDFS.label).getObject()) instanceof Literal) {
            return ((Literal)n).getString();
        }
        if (r.isAnon()) {
            return "<<blank node>>";
        }
        if (pm == null) {
            pm = r.getModel();
        }
        return FusekiBuildLib.strForURI(r.getURI(), pm);
    }

    public static String strForURI(String uri, PrefixMapping pm) {
        String x;
        if (pm != null && !(x = pm.shortForm(uri)).equals(uri)) {
            return x;
        }
        return "<" + uri + ">";
    }
}

