/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.auth.AuthUserList;
import org.apache.jena.fuseki.auth.Users;

public class Auth {
    public static final String dftRealm = "TripleStore";
    public static AuthPolicy ANY_USER = user -> user != null;
    public static AuthPolicy ANY_ANON = user -> true;
    public static AuthPolicy DENY = user -> false;

    public static AuthPolicy policyAllowSpecific(String ... allowedUsers) {
        return Auth.policyAllowSpecific(Arrays.asList(allowedUsers));
    }

    public static AuthPolicy policyAllowSpecific(Collection<String> allowedUsers) {
        Objects.requireNonNull(allowedUsers, "allowedUsers");
        if (allowedUsers.contains(Users.UserAnyLoggedIn)) {
            if (allowedUsers.size() > 1) {
                Fuseki.configLog.warn("Both 'any user' and a list of users given");
            }
            return ANY_USER;
        }
        if (allowedUsers.contains(Users.UserAnyAnon)) {
            if (allowedUsers.size() > 1) {
                Fuseki.configLog.warn("Both 'anon user' and a list of users given");
            }
            return ANY_ANON;
        }
        if (allowedUsers.stream().anyMatch(Objects::isNull)) {
            throw new FusekiConfigException("null user found : " + allowedUsers);
        }
        return new AuthUserList(allowedUsers);
    }

    public static boolean allow(String user, AuthPolicy policy) {
        if (policy == null) {
            return true;
        }
        return policy.isAllowed(user);
    }

    public static boolean allow(String user, AuthPolicy policy, Runnable notAllowed) {
        if (Auth.allow(user, policy)) {
            return true;
        }
        notAllowed.run();
        return false;
    }
}

