/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.riot.system.stream.LocatorFTP;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.transaction.TransactionManager;
import org.apache.jena.util.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fuseki {
    public static String PATH = "org.apache.jena.fuseki";
    public static String FusekiIRI = "http://jena.apache.org/Fuseki";
    public static String FusekiSymbolIRI = "http://jena.apache.org/fuseki#";
    public static String PagesStatic = "pages";
    public static final String BaseParserSPARQL = "http://server/unset-base/";
    public static final String BaseUpload = "http://server/unset-base/";
    private static String metadataLocation = "org/apache/jena/fuseki/fuseki-properties.xml";
    private static Metadata metadata = Fuseki.initMetadata();
    public static final String NAME = "Apache Jena Fuseki";
    public static final String VERSION = metadata.get(PATH + ".version", "development");
    public static final String BUILD_DATE = metadata.get(PATH + ".build.datetime", "unknown");
    public static final boolean GSP_DIRECT_NAMING = false;
    public static boolean developmentMode;
    public static boolean outputJettyServerHeader;
    public static boolean outputFusekiServerHeader;
    public static final String serverHttpName;
    public static final String actionLogName;
    public static final Logger actionLog;
    public static final String requestLogName;
    public static final Logger requestLog;
    public static final String adminLogName;
    public static final Logger adminLog;
    public static final String builderLogName;
    public static final Logger builderLog;
    public static final String validationLogName;
    public static final Logger validationLog;
    public static final String serverLogName;
    public static final Logger serverLog;
    public static final String servletRequestLogName;
    public static final String configLogName;
    public static final Logger configLog;
    public static boolean verboseLogging;
    public static final String attrVerbose = "org.apache.jena.fuseki:verbose";
    public static final String attrNameRegistry = "org.apache.jena.fuseki:DataAccessPointRegistry";
    public static final String attrServiceRegistry = "org.apache.jena.fuseki:ServiceDispatchRegistry";
    public static final String attrAuthorizationService = "org.apache.jena.fuseki:AuthorizationService";
    public static final StreamManager webStreamManager;
    public static String DFT_FUSEKI_HOME;
    public static String DFT_FUSEKI_BASE;
    private static boolean initialized;
    private static final long startMillis;
    private static final Calendar cal;
    private static final String startDateTime;

    private static Metadata initMetadata() {
        Metadata m = new Metadata();
        m.addMetadata(metadataLocation);
        return m;
    }

    public static void setVerbose(ServletContext cxt, boolean verbose) {
        cxt.setAttribute(attrVerbose, verbose);
    }

    public static boolean getVerbose(ServletContext cxt) {
        return (Boolean)cxt.getAttribute(attrVerbose);
    }

    public static long serverUptimeMillis() {
        return System.currentTimeMillis() - startMillis;
    }

    public static long serverUptimeSeconds() {
        long x = System.currentTimeMillis() - startMillis;
        return TimeUnit.MILLISECONDS.toSeconds(x);
    }

    public static String serverStartedAt() {
        return startDateTime;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        JenaSystem.init();
        SystemInfo sysInfo = new SystemInfo(FusekiIRI, PATH, VERSION, BUILD_DATE);
        SystemARQ.registerSubSystem(sysInfo);
        MappingRegistry.addPrefixMapping("fuseki", FusekiSymbolIRI);
        TDB.setOptimizerWarningFlag(false);
        TransactionManager.QueueBatchSize = 0;
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    public static int choosePort() {
        return FusekiNetLib.choosePort();
    }

    public static boolean isFuseki(String datasetURL) {
        HttpOptions request = new HttpOptions(datasetURL);
        HttpClient httpClient = HttpOp.getDefaultHttpClient();
        if (httpClient == null) {
            httpClient = HttpClients.createSystem();
        }
        return Fuseki.isFuseki(request, httpClient, null);
    }

    public static boolean isFuseki(RDFConnectionRemote connection) {
        HttpOptions request = new HttpOptions(connection.getDestination());
        HttpClient httpClient = connection.getHttpClient();
        if (httpClient == null) {
            httpClient = HttpClients.createSystem();
        }
        HttpContext httpContext = connection.getHttpContext();
        return Fuseki.isFuseki(request, httpClient, httpContext);
    }

    private static boolean isFuseki(HttpOptions request, HttpClient httpClient, HttpContext httpContext) {
        try {
            HttpResponse response = httpClient.execute(request);
            String reqId = Fuseki.safeGetHeader(response, "Fuseki-Request-ID");
            if (reqId != null) {
                return true;
            }
            String serverIdent = Fuseki.safeGetHeader(response, "Server");
            if (serverIdent != null) {
                Log.debug(ARQ.getHttpRequestLogger(), "Server: " + serverIdent);
                boolean isFuseki = serverIdent.startsWith(NAME);
                if (!isFuseki) {
                    isFuseki = serverIdent.toLowerCase().contains("fuseki");
                }
                return isFuseki;
            }
            return false;
        }
        catch (IOException ex) {
            throw new HttpException("Failed to check for a Fuseki server", ex);
        }
    }

    static String safeGetHeader(HttpResponse response, String header) {
        Header h = response.getFirstHeader(header);
        if (h == null) {
            return null;
        }
        return h.getValue();
    }

    static {
        outputJettyServerHeader = developmentMode = VERSION == null || VERSION.equals("development") || VERSION.contains("SNAPSHOT");
        outputFusekiServerHeader = developmentMode;
        serverHttpName = "Apache Jena Fuseki (" + VERSION + ")";
        actionLogName = PATH + ".Fuseki";
        actionLog = LoggerFactory.getLogger(actionLogName);
        requestLogName = PATH + ".Request";
        requestLog = LoggerFactory.getLogger(requestLogName);
        adminLogName = PATH + ".Admin";
        adminLog = LoggerFactory.getLogger(adminLogName);
        builderLogName = PATH + ".Builder";
        builderLog = LoggerFactory.getLogger(builderLogName);
        validationLogName = PATH + ".Validate";
        validationLog = LoggerFactory.getLogger(adminLogName);
        serverLogName = PATH + ".Server";
        serverLog = LoggerFactory.getLogger(serverLogName);
        servletRequestLogName = PATH + ".Servlet";
        configLogName = PATH + ".Config";
        configLog = LoggerFactory.getLogger(configLogName);
        verboseLogging = false;
        webStreamManager = new StreamManager();
        webStreamManager.addLocator(new LocatorHTTP());
        webStreamManager.addLocator(new LocatorFTP());
        DFT_FUSEKI_HOME = ".";
        DFT_FUSEKI_BASE = ".";
        initialized = false;
        startMillis = System.currentTimeMillis();
        cal = Calendar.getInstance(TimeZone.getTimeZone("00:00"));
        cal.setTimeInMillis(startMillis);
        startDateTime = DateTimeUtils.calendarToXSDDateTimeString(cal);
        Fuseki.init();
    }
}

