/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.org.pcollections;

import io.micrometer.shaded.org.pcollections.IntTree;
import io.micrometer.shaded.org.pcollections.PMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class IntTreePMap<V>
extends AbstractMap<Integer, V>
implements PMap<Integer, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final IntTreePMap<Object> EMPTY = new IntTreePMap<Object>(IntTree.EMPTYNODE);
    private final IntTree<V> root;
    private Set<Map.Entry<Integer, V>> entrySet = null;

    public static <V> IntTreePMap<V> empty() {
        return EMPTY;
    }

    public static <V> IntTreePMap<V> singleton(Integer key, V value) {
        return IntTreePMap.empty().plus(key, value);
    }

    public static <V> IntTreePMap<V> from(Map<? extends Integer, ? extends V> map) {
        if (map instanceof IntTreePMap) {
            return (IntTreePMap)map;
        }
        return IntTreePMap.empty().plusAll((Map)map);
    }

    private IntTreePMap(IntTree<V> root2) {
        this.root = root2;
    }

    private IntTreePMap<V> withRoot(IntTree<V> root2) {
        if (root2 == this.root) {
            return this;
        }
        return new IntTreePMap<V>(root2);
    }

    IntTreePMap<V> withKeysChangedAbove(int key, int delta) {
        return this.withRoot(this.root.changeKeysAbove(key, delta));
    }

    IntTreePMap<V> withKeysChangedBelow(int key, int delta) {
        return this.withRoot(this.root.changeKeysBelow(key, delta));
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, V>>(){

                @Override
                public int size() {
                    return IntTreePMap.this.size();
                }

                @Override
                public Iterator<Map.Entry<Integer, V>> iterator() {
                    return IntTreePMap.this.root.iterator();
                }

                @Override
                public boolean contains(Object e2) {
                    if (!(e2 instanceof Map.Entry)) {
                        return false;
                    }
                    Object value = IntTreePMap.this.get(((Map.Entry)e2).getKey());
                    return value != null && value.equals(((Map.Entry)e2).getValue());
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof Integer)) {
            return false;
        }
        return this.root.containsKey(((Integer)key).intValue());
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof Integer)) {
            return null;
        }
        return this.root.get(((Integer)key).intValue());
    }

    public IntTreePMap<V> plus(Integer key, V value) {
        return this.withRoot(this.root.plus(key.intValue(), value));
    }

    public IntTreePMap<V> minus(Object key) {
        if (!(key instanceof Integer)) {
            return this;
        }
        return this.withRoot(this.root.minus(((Integer)key).intValue()));
    }

    public IntTreePMap<V> plusAll(Map<? extends Integer, ? extends V> map) {
        IntTree<V> root2 = this.root;
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            root2 = root2.plus(entry.getKey().intValue(), entry.getValue());
        }
        return this.withRoot(root2);
    }

    public IntTreePMap<V> minusAll(Collection<?> keys) {
        IntTree<V> root2 = this.root;
        for (Object key : keys) {
            if (!(key instanceof Integer)) continue;
            root2 = root2.minus(((Integer)key).intValue());
        }
        return this.withRoot(root2);
    }
}

