/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.internal;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultLongTaskTimer
extends AbstractMeter
implements LongTaskTimer {
    private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
    private final AtomicLong nextTask = new AtomicLong(0L);
    private final Clock clock;

    public DefaultLongTaskTimer(Meter.Id id, Clock clock) {
        super(id);
        this.clock = clock;
    }

    @Override
    public LongTaskTimer.Sample start() {
        long task = this.nextTask.getAndIncrement();
        this.tasks.put(task, this.clock.monotonicTime());
        return new LongTaskTimer.Sample(this, task);
    }

    @Override
    public long stop(long task) {
        Long startTime = (Long)this.tasks.get(task);
        if (startTime != null) {
            this.tasks.remove(task);
            return this.clock.monotonicTime() - startTime;
        }
        return -1L;
    }

    @Override
    public double duration(long task, TimeUnit unit) {
        Long startTime = (Long)this.tasks.get(task);
        return startTime != null ? TimeUtils.nanosToUnit(this.clock.monotonicTime() - startTime, unit) : -1.0;
    }

    @Override
    public double duration(TimeUnit unit) {
        long now2 = this.clock.monotonicTime();
        long sum = 0L;
        Iterator iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            long startTime = (Long)iterator.next();
            sum += now2 - startTime;
        }
        return TimeUtils.nanosToUnit(sum, unit);
    }

    @Override
    public int activeTasks() {
        return this.tasks.size();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

