/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.internal.TimedExecutor;
import io.micrometer.core.instrument.internal.TimedExecutorService;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;

@NonNullApi
@NonNullFields
public class ExecutorServiceMetrics
implements MeterBinder {
    @Nullable
    private final ExecutorService executorService;
    private final Iterable<Tag> tags;

    public ExecutorServiceMetrics(@Nullable ExecutorService executorService, String executorServiceName, Iterable<Tag> tags) {
        this.executorService = executorService;
        this.tags = Tags.concat(tags, "name", executorServiceName);
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String executorName, Iterable<Tag> tags) {
        if (executor instanceof ExecutorService) {
            return ExecutorServiceMetrics.monitor(registry, (ExecutorService)executor, executorName, tags);
        }
        return new TimedExecutor(registry, executor, executorName, tags);
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String executorName, Tag ... tags) {
        return ExecutorServiceMetrics.monitor(registry, executor, executorName, Arrays.asList(tags));
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String executorServiceName, Iterable<Tag> tags) {
        new ExecutorServiceMetrics(executor, executorServiceName, tags).bindTo(registry);
        return new TimedExecutorService(registry, executor, executorServiceName, tags);
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String executorServiceName, Tag ... tags) {
        return ExecutorServiceMetrics.monitor(registry, executor, executorServiceName, Arrays.asList(tags));
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (this.executorService == null) {
            return;
        }
        String className = this.executorService.getClass().getName();
        if (this.executorService instanceof ThreadPoolExecutor) {
            this.monitor(registry, (ThreadPoolExecutor)this.executorService);
        } else if (className.equals("java.util.concurrent.Executors$DelegatedScheduledExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass()));
        } else if (className.equals("java.util.concurrent.Executors$FinalizableDelegatedExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass().getSuperclass()));
        } else if (this.executorService instanceof ForkJoinPool) {
            this.monitor(registry, (ForkJoinPool)this.executorService);
        }
    }

    @Nullable
    private ThreadPoolExecutor unwrapThreadPoolExecutor(ExecutorService executor, Class<?> wrapper) {
        try {
            Field e2 = wrapper.getDeclaredField("e");
            e2.setAccessible(true);
            return (ThreadPoolExecutor)e2.get(this.executorService);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    private void monitor(MeterRegistry registry, @Nullable ThreadPoolExecutor tp) {
        if (tp == null) {
            return;
        }
        FunctionCounter.builder("executor.completed", tp, ThreadPoolExecutor::getCompletedTaskCount).tags(this.tags).description("The approximate total number of tasks that have completed execution").baseUnit("tasks").register(registry);
        Gauge.builder("executor.active", tp, ThreadPoolExecutor::getActiveCount).tags(this.tags).description("The approximate number of threads that are actively executing tasks").baseUnit("threads").register(registry);
        Gauge.builder("executor.queued", tp, tpRef -> tpRef.getQueue().size()).tags(this.tags).description("The approximate number of tasks that are queued for execution").baseUnit("tasks").register(registry);
        Gauge.builder("executor.pool.size", tp, ThreadPoolExecutor::getPoolSize).tags(this.tags).description("The current number of threads in the pool").baseUnit("threads").register(registry);
    }

    private void monitor(MeterRegistry registry, ForkJoinPool fj) {
        FunctionCounter.builder("executor.steals", fj, ForkJoinPool::getStealCount).tags(this.tags).description("Estimate of the total number of tasks stolen from one thread's work queue by another. The reported value underestimates the actual total number of steals when the pool is not quiescent").register(registry);
        Gauge.builder("executor.queued", fj, ForkJoinPool::getQueuedTaskCount).tags(this.tags).description("An estimate of the total number of tasks currently held in queues by worker threads").register(registry);
        Gauge.builder("executor.active", fj, ForkJoinPool::getActiveThreadCount).tags(this.tags).description("An estimate of the number of threads that are currently stealing or executing tasks").register(registry);
        Gauge.builder("executor.running", fj, ForkJoinPool::getRunningThreadCount).tags(this.tags).description("An estimate of the number of worker threads that are not blocked waiting to join tasks or for other managed synchronization threads").register(registry);
    }
}

