/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.BlobType;
import org.jclouds.azureblob.domain.LeaseStatus;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.internal.BlobPropertiesImpl;
import org.jclouds.azureblob.domain.internal.HashSetListBlobsResponse;
import org.jclouds.azureblob.xml.ContainerNameEnumerationResultsHandler;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ContainerNameEnumerationResultsHandlerTest")
public class ContainerNameEnumerationResultsHandlerTest
extends BaseHandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test_list_blobs.xml");
        ImmutableSet contents = ImmutableSet.of((Object)new BlobPropertiesImpl(BlobType.BLOCK_BLOB, AccessTier.HOT, "blob1.txt", "mycontainer", URI.create("http://myaccount.blob.core.windows.net/mycontainer/blob1.txt"), this.dateService.rfc822DateParse("Thu, 18 Sep 2008 18:41:57 GMT"), "0x8CAE7D55D050B8B", 8L, "text/plain; charset=UTF-8", null, null, null, null, LeaseStatus.UNLOCKED, (Map)ImmutableMap.of()), (Object)new BlobPropertiesImpl(BlobType.BLOCK_BLOB, AccessTier.COOL, "blob2.txt", "mycontainer", URI.create("http://myaccount.blob.core.windows.net/mycontainer/blob2.txt"), this.dateService.rfc822DateParse("Thu, 18 Sep 2008 18:41:57 GMT"), "0x8CAE7D55CF6C339", 14L, "text/plain; charset=UTF-8", null, null, null, null, LeaseStatus.UNLOCKED, (Map)ImmutableMap.of()), (Object)new BlobPropertiesImpl(BlobType.PAGE_BLOB, AccessTier.ARCHIVE, "newblob1.txt", "mycontainer", URI.create("http://myaccount.blob.core.windows.net/mycontainer/newblob1.txt"), this.dateService.rfc822DateParse("Thu, 18 Sep 2008 18:41:57 GMT"), "0x8CAE7D55CF6C339", 25L, "text/plain; charset=UTF-8", null, null, null, null, LeaseStatus.UNLOCKED, (Map)ImmutableMap.of()));
        HashSetListBlobsResponse list = new HashSetListBlobsResponse((Iterable)contents, URI.create("http://myaccount.blob.core.windows.net/mycontainer"), "myfolder/", null, Integer.valueOf(4), "newblob2.txt", null, (Iterable)ImmutableSet.of((Object)"myfolder/"));
        ListBlobsResponse result = (ListBlobsResponse)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ContainerNameEnumerationResultsHandler.class)).parse(is);
        Assert.assertEquals((Set)result, (Set)list);
    }

    public void testOptions() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test_list_blobs_options.xml");
        ImmutableSet contents = ImmutableSet.of((Object)new BlobPropertiesImpl(BlobType.BLOCK_BLOB, AccessTier.HOT, "a", "adriancole-blobstore3", URI.create("https://jclouds.blob.core.windows.net/adriancole-blobstore3/a"), this.dateService.rfc822DateParse("Sat, 30 Jan 2010 17:46:15 GMT"), "0x8CC6FEB41736428", 8L, "application/octet-stream", null, null, null, null, LeaseStatus.UNLOCKED, (Map)ImmutableMap.of()));
        HashSetListBlobsResponse list = new HashSetListBlobsResponse((Iterable)contents, URI.create("https://jclouds.blob.core.windows.net/adriancole-blobstore3"), null, null, Integer.valueOf(1), "2!68!MDAwMDA2IWFwcGxlcyEwMDAwMjghOTk5OS0xMi0zMVQyMzo1OTo1OS45OTk5OTk5WiE-", "/", (Iterable)Sets.newTreeSet());
        ListBlobsResponse result = (ListBlobsResponse)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ContainerNameEnumerationResultsHandler.class)).parse(is);
        Assert.assertEquals((Set)result, (Set)list);
    }
}

