/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.xml;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.domain.internal.BoundedHashSet;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.domain.internal.ContainerPropertiesImpl;
import org.jclouds.azureblob.xml.AccountNameEnumerationResultsHandler;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="blob.AccountNameEnumerationResultsHandlerTest")
public class AccountNameEnumerationResultsHandlerTest
extends BaseHandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test_list_containers.xml");
        TreeSet contents = Sets.newTreeSet();
        contents.add(new ContainerPropertiesImpl(URI.create("http://myaccount.blob.core.windows.net/audio"), this.dateService.rfc822DateParse("Wed, 13 Aug 2008 20:39:39 GMT"), "0x8CACB9BD7C6B1B2", (Map)Maps.newHashMap(), PublicAccess.CONTAINER));
        contents.add(new ContainerPropertiesImpl(URI.create("http://myaccount.blob.core.windows.net/images"), this.dateService.rfc822DateParse("Wed, 14 Aug 2008 20:39:39 GMT"), "0x8CACB9BD7C1EEEC", (Map)Maps.newHashMap(), PublicAccess.BLOB));
        contents.add(new ContainerPropertiesImpl(URI.create("http://myaccount.blob.core.windows.net/textfiles"), this.dateService.rfc822DateParse("Wed, 15 Aug 2008 20:39:39 GMT"), "0x8CACB9BD7BACAC3", (Map)Maps.newHashMap(), PublicAccess.PRIVATE));
        BoundedHashSet list = new BoundedHashSet((Iterable)contents, URI.create("http://myaccount.blob.core.windows.net/"), null, null, Integer.valueOf(3), "video");
        BoundedSet result = (BoundedSet)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(AccountNameEnumerationResultsHandler.class)).parse(is);
        Assert.assertEquals((Set)result, (Set)list);
    }

    public void testApplyInputStreamWithOptions() {
        TreeSet contents = Sets.newTreeSet();
        contents.add(new ContainerPropertiesImpl(URI.create("http://myaccount.blob.core.windows.net/audio"), this.dateService.rfc822DateParse("Wed, 13 Aug 2008 20:39:39 GMT"), "0x8CACB9BD7C6B1B2", (Map)Maps.newHashMap(), PublicAccess.CONTAINER));
        contents.add(new ContainerPropertiesImpl(URI.create("http://myaccount.blob.core.windows.net/images"), this.dateService.rfc822DateParse("Wed, 14 Aug 2008 20:39:39 GMT"), "0x8CACB9BD7C1EEEC", (Map)Maps.newHashMap(), PublicAccess.BLOB));
        contents.add(new ContainerPropertiesImpl(URI.create("http://myaccount.blob.core.windows.net/textfiles"), this.dateService.rfc822DateParse("Wed, 15 Aug 2008 20:39:39 GMT"), "0x8CACB9BD7BACAC3", (Map)Maps.newHashMap(), PublicAccess.PRIVATE));
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test_list_containers_options.xml");
        BoundedHashSet list = new BoundedHashSet((Iterable)contents, URI.create("http://myaccount.blob.core.windows.net"), "prefix", "marker", Integer.valueOf(1), "video");
        BoundedSet result = (BoundedSet)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(AccountNameEnumerationResultsHandler.class)).parse(is);
        Assert.assertEquals((Set)result, (Set)list);
    }
}

