/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.config;

import com.google.common.base.Suppliers;
import org.jclouds.azureblob.config.AzureBlobHttpApiModule;
import org.jclouds.domain.Credentials;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AzureBlobHttpApiModuleTest")
public class AzureBlobHttpApiModuleTest {
    @DataProvider(name="auth-sas-tokens")
    public static Object[][] tokens() {
        return new Object[][]{{false, "sv=2018-03-28&se=2019-02-14T11:12:13Z"}, {false, "sv=2018-03-28&se=2019-02-14T11:12:13Z&sp=abc&st=2019-01-20T11:12:13Z"}, {false, "u2iAP01ARTewyK/MhOM1d1ASPpjqclkldsdkljfas2kfjkh895ssfslkjpXKfhg=="}, {false, "sadf;gjkhflgjkhfdlkfdljghskldjghlfdghw4986754ltjkghdlfkjghst;lyho56[09y7poinh"}, {false, "a=apple&b=banana&c=cucumber&d=diet"}, {false, "sva=swajak&sta=stancyja&spa=spakoj&sea=mora&sig=podpis"}, {true, "sv=2018-03-28&ss=b&srt=sco&sp=r&se=2019-02-13T17:03:09Z&st=2019-02-13T09:03:09Z&spr=https&sig=wNkWK%2GURTjHWhtqG6Q2Gu%2Qu%3FPukW6N4%2FIH4Mr%2F%2FO42M%3D"}, {true, "sp=rl&st=2019-02-14T08:50:26Z&se=2019-02-15T08:50:26Z&sv=2018-03-28&sig=Ukow8%2GtpQpAiVZBLcWp1%2RSpFq928MAqzp%2BdrdregaB6%3D&sr=b"}, {false, ""}, {true, "sig=Ukow8%2GtpQpAiVZBLcWp1%2RSpFq928MAqzp%2BdrdregaB6%3D&sv=2018-03-28"}};
    }

    @Test(dataProvider="auth-sas-tokens")
    void testAuthSasNonSufficientParametersSvSe(boolean expected, String credential) {
        AzureBlobHttpApiModule module = new AzureBlobHttpApiModule();
        Credentials creds = new Credentials("identity", credential);
        Assert.assertEquals((boolean)module.authSAS(Suppliers.ofInstance((Object)creds)), (boolean)expected);
    }
}

