/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.BlobMetadataToBlobProperties;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.azureblob.domain.internal.HashSetListBlobsResponse;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;

@Singleton
public class ResourceToListBlobsResponse
implements Function<PageSet<? extends StorageMetadata>, ListBlobsResponse> {
    private final BlobMetadataToBlobProperties blob2ObjectMd;

    @Inject
    public ResourceToListBlobsResponse(BlobMetadataToBlobProperties blob2ObjectMd) {
        this.blob2ObjectMd = blob2ObjectMd;
    }

    public ListBlobsResponse apply(PageSet<? extends StorageMetadata> list) {
        Iterable contents = Iterables.transform((Iterable)Iterables.filter(list, (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        }), (Function)new Function<StorageMetadata, BlobProperties>(){

            public MutableBlobProperties apply(StorageMetadata from) {
                return ResourceToListBlobsResponse.this.blob2ObjectMd.apply((BlobMetadata)from);
            }
        });
        TreeSet commonPrefixes = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)Iterables.filter(list, (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.RELATIVE_PATH;
            }
        }), (Function)new Function<StorageMetadata, String>(){

            public String apply(StorageMetadata from) {
                return from.getName();
            }
        }));
        return new HashSetListBlobsResponse(contents, null, null, null, null, list.getNextMarker(), "/", (Iterable)commonPrefixes);
    }
}

