/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.jclouds.azure.storage.AzureStorageResponseException;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobBlockProperties;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.ListBlobsInclude;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CopyBlobOptions;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.util.Strings2;
import org.jclouds.util.Throwables2;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AzureBlobClientLiveTest
extends BaseBlobStoreIntegrationTest {
    String privateContainer;
    String publicContainer;

    public AzureBlobClientLiveTest() {
        this.provider = "azureblob";
    }

    public AzureBlobClient getApi() {
        return (AzureBlobClient)((BlobStoreContext)this.view).unwrapApi(AzureBlobClient.class);
    }

    @Test
    public void testListContainers() throws Exception {
        BoundedSet response = this.getApi().listContainers(new ListOptions[0]);
        assert (null != response);
        long initialContainerCount = response.size();
        Assert.assertTrue((initialContainerCount >= 0L ? 1 : 0) != 0);
    }

    @Test(timeOut=300000L)
    public void testCreateContainer() throws Exception {
        boolean created = false;
        while (!created) {
            this.privateContainer = CONTAINER_PREFIX + "unique-" + containerIndex.incrementAndGet();
            try {
                created = this.getApi().createContainer(this.privateContainer, new CreateContainerOptions[]{CreateContainerOptions.Builder.withMetadata((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"bar"))});
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 409) continue;
                throw e;
            }
        }
        BoundedSet response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.includeMetadata()});
        assert (null != response);
        long containerCount = response.size();
        Assert.assertTrue((containerCount >= 1L ? 1 : 0) != 0);
        ListBlobsResponse list = this.getApi().listBlobs(this.privateContainer, new ListBlobsOptions[0]);
        Assert.assertEquals((Object)list.getUrl(), (Object)URI.create(String.format("https://%s.blob.core.windows.net/%s", ((BlobStoreContext)this.view).unwrap().getIdentity(), this.privateContainer)));
    }

    @Test(timeOut=300000L)
    public void testCreatePublicContainer() throws Exception {
        boolean created = false;
        while (!created) {
            this.publicContainer = CONTAINER_PREFIX + containerIndex.incrementAndGet();
            try {
                created = this.getApi().createContainer(this.publicContainer, new CreateContainerOptions[]{CreateContainerOptions.Builder.withPublicAccess((PublicAccess)PublicAccess.BLOB)});
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 409) continue;
                throw e;
            }
        }
        ContainerProperties properties = null;
        for (ContainerProperties p : this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.includeMetadata()})) {
            if (!p.getName().equals(this.publicContainer)) continue;
            properties = p;
            break;
        }
        Assertions.assertThat((Comparable)properties.getPublicAccess()).isEqualTo((Object)PublicAccess.BLOB);
        properties = this.getApi().getContainerProperties(this.publicContainer);
        Assertions.assertThat((Comparable)properties.getPublicAccess()).isEqualTo((Object)PublicAccess.BLOB);
    }

    @Test(timeOut=600000L)
    public void testCreatePublicRootContainer() throws Exception {
        try {
            this.getApi().deleteRootContainer();
        }
        catch (ContainerNotFoundException e) {
            Thread.sleep(5000L);
        }
        catch (AzureStorageResponseException htpe) {
            if (htpe.getResponse().getStatusCode() == 409) {
                Thread.sleep(5000L);
            }
            throw htpe;
        }
        boolean created = false;
        while (!created) {
            try {
                created = this.getApi().createRootContainer(new CreateContainerOptions[0]);
            }
            catch (AzureStorageResponseException htpe) {
                if (htpe.getResponse().getStatusCode() == 409) {
                    Thread.sleep(5000L);
                    continue;
                }
                throw htpe;
            }
        }
        ListBlobsResponse list = this.getApi().listBlobs(new ListBlobsOptions[0]);
        Assert.assertEquals((Object)list.getUrl(), (Object)URI.create(String.format("https://%s.blob.core.windows.net/$root", ((BlobStoreContext)this.view).unwrap().getIdentity())));
    }

    @Test
    public void testListContainersWithOptions() throws Exception {
        BoundedSet response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.prefix((String)this.privateContainer).maxResults(1).includeMetadata()});
        assert (null != response);
        long initialContainerCount = response.size();
        Assert.assertTrue((initialContainerCount >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)this.privateContainer, (String)response.getPrefix());
        Assert.assertEquals((int)1, (int)response.getMaxResults());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreatePublicRootContainer"})
    public void testDeleteRootContainer() throws Exception {
        this.getApi().deleteRootContainer();
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer", "testCreatePublicContainer"})
    public void testListOwnedContainers() throws Exception {
        BoundedSet response = this.getApi().listContainers(new ListOptions[0]);
        response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.prefix((String)this.privateContainer.substring(0, this.privateContainer.length() - 1)).maxResults(1).includeMetadata()});
        Assert.assertEquals((int)response.size(), (int)1);
        Assert.assertEquals((String)((ContainerProperties)Iterables.getOnlyElement((Iterable)response)).getName(), (String)this.privateContainer);
        Assert.assertEquals((Map)((ContainerProperties)Iterables.getOnlyElement((Iterable)response)).getMetadata(), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.prefix((String)this.publicContainer).maxResults(1)});
        Assert.assertEquals((int)response.size(), (int)1);
        Assert.assertEquals((String)((ContainerProperties)Iterables.getOnlyElement((Iterable)response)).getName(), (String)this.publicContainer);
    }

    @Test
    public void testDeleteOneContainer() throws Exception {
        this.getApi().deleteContainer("does-not-exist");
    }

    @Test(timeOut=300000L, dependsOnMethods={"testListOwnedContainers", "testObjectOperations"})
    public void testDeleteContainer() throws Exception {
        this.getApi().deleteContainer(this.privateContainer);
        this.getApi().deleteContainer(this.publicContainer);
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer", "testCreatePublicContainer"})
    public void testObjectOperations() throws Exception {
        String data = "Here is my data";
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("object");
        object.setPayload(data);
        object.getProperties().getContentMetadata().setContentMD5(Hashing.md5().hashString((CharSequence)data, Charsets.UTF_8).asBytes());
        object.getProperties().getContentMetadata().setContentType("text/plain");
        object.getProperties().getMetadata().put("mykey", "metadata-value");
        byte[] md5 = object.getProperties().getContentMetadata().getContentMD5();
        String newEtag = this.getApi().putBlob(this.privateContainer, object);
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(md5), (String)BaseEncoding.base16().lowerCase().encode(object.getProperties().getContentMetadata().getContentMD5()));
        assert (this.getApi().getBlobProperties(this.privateContainer, "non-existent-object") == null);
        BlobProperties metadata = this.getApi().getBlobProperties(this.privateContainer, object.getProperties().getName());
        Assert.assertEquals((String)metadata.getName(), (String)object.getProperties().getName());
        Assert.assertEquals((Object)metadata.getContentMetadata().getContentLength(), (Object)data.length());
        Assert.assertEquals((String)metadata.getContentMetadata().getContentType(), (String)"text/plain");
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(metadata.getContentMetadata().getContentMD5()), (String)BaseEncoding.base16().lowerCase().encode(object.getProperties().getContentMetadata().getContentMD5()));
        Assert.assertEquals((String)metadata.getETag(), (String)newEtag);
        Assert.assertEquals((int)metadata.getMetadata().entrySet().size(), (int)1);
        Assert.assertEquals((String)((String)metadata.getMetadata().get("mykey")), (String)"metadata-value");
        ImmutableMap userMetadata = ImmutableMap.builder().put((Object)"new_metadata_1", (Object)"value-1").put((Object)"new_metadata_2", (Object)"value-2").build();
        String eTag = this.getApi().setBlobMetadata(this.privateContainer, object.getProperties().getName(), (Map)userMetadata);
        Assertions.assertThat((String)eTag).isNotNull();
        String eTag2 = this.getApi().setBlobMetadata(this.privateContainer, object.getProperties().getName(), (Map)userMetadata);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)eTag2).isNotNull()).isNotEqualTo((Object)eTag);
        assert (this.getApi().getBlob(this.privateContainer, "non-existent-object", new GetOptions[0]) == null);
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, object.getProperties().getName(), new GetOptions[0]);
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)getBlob.getPayload().openStream()), (String)data);
        Assert.assertEquals((String)getBlob.getProperties().getName(), (String)object.getProperties().getName());
        Assert.assertEquals((Object)getBlob.getPayload().getContentMetadata().getContentLength(), (Object)data.length());
        Assert.assertEquals((String)getBlob.getProperties().getContentMetadata().getContentType(), (String)"text/plain");
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(md5), (String)BaseEncoding.base16().lowerCase().encode(getBlob.getProperties().getContentMetadata().getContentMD5()));
        Assert.assertEquals((int)getBlob.getProperties().getMetadata().size(), (int)2);
        Assert.assertEquals((String)((String)getBlob.getProperties().getMetadata().get("new_metadata_1")), (String)"value-1");
        Assert.assertEquals((String)((String)getBlob.getProperties().getMetadata().get("new_metadata_2")), (String)"value-2");
        Assert.assertEquals((int)metadata.getMetadata().entrySet().size(), (int)1);
        Assert.assertEquals((String)((String)metadata.getMetadata().get("mykey")), (String)"metadata-value");
        ListBlobsResponse response = this.getApi().listBlobs(this.privateContainer, new ListBlobsOptions[]{ListBlobsOptions.Builder.prefix((String)object.getProperties().getName().substring(0, object.getProperties().getName().length() - 1)).maxResults(1).includeMetadata()});
        Assert.assertEquals((int)response.size(), (int)1);
        Assert.assertEquals((String)((BlobProperties)Iterables.getOnlyElement((Iterable)response)).getName(), (String)object.getProperties().getName());
        Assert.assertEquals((int)((BlobProperties)Iterables.getOnlyElement((Iterable)response)).getMetadata().size(), (int)2);
        Assert.assertEquals((String)((String)((BlobProperties)Iterables.getOnlyElement((Iterable)response)).getMetadata().get("new_metadata_1")), (String)"value-1");
        Assert.assertEquals((String)((String)((BlobProperties)Iterables.getOnlyElement((Iterable)response)).getMetadata().get("new_metadata_2")), (String)"value-2");
        String correctEtag = newEtag;
        String incorrectEtag = "0" + correctEtag.substring(1);
        object.getProperties().setETag(incorrectEtag);
        try {
            this.getApi().putBlob(this.privateContainer, object);
        }
        catch (Throwable e) {
            Assert.assertEquals(e.getCause().getClass(), HttpResponseException.class);
            Assert.assertEquals((int)((HttpResponseException)e.getCause()).getResponse().getStatusCode(), (int)422);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes(Charsets.UTF_8));
        object = this.getApi().newBlob();
        object.getProperties().setName("chunked-object");
        object.setPayload((InputStream)bais);
        object.getPayload().getContentMetadata().setContentLength(Long.valueOf(data.getBytes().length));
        newEtag = this.getApi().putBlob(this.privateContainer, object);
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(md5), (String)BaseEncoding.base16().lowerCase().encode(getBlob.getProperties().getContentMetadata().getContentMD5()));
        try {
            this.getApi().getBlob(this.privateContainer, object.getProperties().getName(), new GetOptions[]{GetOptions.Builder.ifETagDoesntMatch((String)newEtag)});
        }
        catch (Exception e) {
            HttpResponseException httpEx = (HttpResponseException)Throwables2.getFirstThrowableOfType((Throwable)e, HttpResponseException.class);
            assert (httpEx != null) : "expected http exception, not " + e;
            Assert.assertEquals((int)httpEx.getResponse().getStatusCode(), (int)304);
        }
        try {
            getBlob = this.getApi().getBlob(this.privateContainer, object.getProperties().getName(), new GetOptions[]{GetOptions.Builder.ifETagMatches((String)newEtag)});
            Assert.assertEquals((String)getBlob.getProperties().getETag(), (String)newEtag);
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)412);
        }
        getBlob = this.getApi().getBlob(this.privateContainer, object.getProperties().getName(), new GetOptions[]{GetOptions.Builder.startAt((long)8L)});
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)getBlob.getPayload().openStream()), (String)data.substring(8));
        this.getApi().deleteBlob(this.privateContainer, "object");
        this.getApi().deleteBlob(this.privateContainer, "chunked-object");
    }

    @Test(timeOut=300000L)
    public void testBlockOperations() throws Exception {
        String blockContainer = CONTAINER_PREFIX + containerIndex.incrementAndGet();
        String blockBlob = "myblockblob-" + new SecureRandom().nextInt();
        String A = "A";
        String B = "B";
        String C = "C";
        String blockIdA = BaseEncoding.base64().encode((blockBlob + "-" + A).getBytes());
        String blockIdB = BaseEncoding.base64().encode((blockBlob + "-" + B).getBytes());
        String blockIdC = BaseEncoding.base64().encode((blockBlob + "-" + C).getBytes());
        this.getApi().createContainer(blockContainer, new CreateContainerOptions[0]);
        this.getApi().putBlock(blockContainer, blockBlob, blockIdA, (Payload)Payloads.newByteArrayPayload((byte[])A.getBytes()));
        this.getApi().putBlock(blockContainer, blockBlob, blockIdB, (Payload)Payloads.newByteArrayPayload((byte[])B.getBytes()));
        this.getApi().putBlock(blockContainer, blockBlob, blockIdC, (Payload)Payloads.newByteArrayPayload((byte[])C.getBytes()));
        ListBlobsResponse blobs = this.getApi().listBlobs(blockContainer, new ListBlobsOptions[0]);
        Assertions.assertThat((Iterable)blobs).isEmpty();
        blobs = this.getApi().listBlobs(blockContainer, new ListBlobsOptions[]{new ListBlobsOptions().include(EnumSet.allOf(ListBlobsInclude.class))});
        Assertions.assertThat((Iterable)blobs).hasSize(1);
        this.getApi().putBlockList(blockContainer, blockBlob, Arrays.asList(blockIdA, blockIdB, blockIdC));
        ListBlobBlocksResponse blocks = this.getApi().getBlockList(blockContainer, blockBlob);
        Assert.assertEquals((int)3, (int)blocks.getBlocks().size());
        Assert.assertEquals((String)blockIdA, (String)((BlobBlockProperties)blocks.getBlocks().get(0)).getBlockName());
        Assert.assertEquals((String)blockIdB, (String)((BlobBlockProperties)blocks.getBlocks().get(1)).getBlockName());
        Assert.assertEquals((String)blockIdC, (String)((BlobBlockProperties)blocks.getBlocks().get(2)).getBlockName());
        Assert.assertEquals((long)1L, (long)((BlobBlockProperties)blocks.getBlocks().get(0)).getContentLength());
        Assert.assertEquals((long)1L, (long)((BlobBlockProperties)blocks.getBlocks().get(1)).getContentLength());
        Assert.assertEquals((long)1L, (long)((BlobBlockProperties)blocks.getBlocks().get(2)).getContentLength());
        this.getApi().deleteContainer(blockContainer);
    }

    @Test
    public void testGetSetACL() throws Exception {
        AzureBlobClient client = this.getApi();
        String blockContainer = CONTAINER_PREFIX + containerIndex.incrementAndGet();
        client.createContainer(blockContainer, new CreateContainerOptions[0]);
        try {
            Assertions.assertThat((Comparable)client.getPublicAccessForContainer(blockContainer)).isEqualTo((Object)PublicAccess.PRIVATE);
            AzureBlobClientLiveTest.setAndVerifyACL(client, blockContainer, PublicAccess.CONTAINER);
            AzureBlobClientLiveTest.setAndVerifyACL(client, blockContainer, PublicAccess.BLOB);
            AzureBlobClientLiveTest.setAndVerifyACL(client, blockContainer, PublicAccess.PRIVATE);
        }
        finally {
            client.deleteContainer(blockContainer);
        }
    }

    private static void setAndVerifyACL(AzureBlobClient client, String blockContainer, PublicAccess access) throws Exception {
        client.setPublicAccessForContainer(blockContainer, access);
        Assertions.assertThat((Comparable)client.getPublicAccessForContainer(blockContainer)).isEqualTo((Object)access);
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testCopyBlob() throws Exception {
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("from");
        object.setPayload(byteSource.read());
        this.getApi().putBlob(this.privateContainer, object);
        URI copySource = ((BlobStoreContext)this.view).getSigner().signGetBlob(this.privateContainer, "from").getEndpoint();
        this.getApi().copyBlob(copySource, this.privateContainer, "to", CopyBlobOptions.NONE);
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, "to", new GetOptions[0]);
        Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)getBlob.getPayload().openStream()), (byte[])byteSource.read());
        Assertions.assertThat((boolean)getBlob.getProperties().getMetadata().isEmpty());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testCopyBlobReplaceMetadata() throws Exception {
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("from");
        object.setPayload(byteSource.read());
        this.getApi().putBlob(this.privateContainer, object);
        URI copySource = ((BlobStoreContext)this.view).getSigner().signGetBlob(this.privateContainer, "from").getEndpoint();
        ImmutableMap newMetadata = ImmutableMap.of((Object)"foo", (Object)"bar");
        this.getApi().copyBlob(copySource, this.privateContainer, "to", CopyBlobOptions.builder().overrideUserMetadata((Map)newMetadata).build());
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, "to", new GetOptions[0]);
        Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)getBlob.getPayload().openStream()), (byte[])byteSource.read());
        Assertions.assertThat((Map)getBlob.getProperties().getMetadata()).isEqualTo((Object)newMetadata);
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testCopyBlobIfModifiedSince() throws Exception {
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("from");
        object.setPayload(byteSource.read());
        String eTag = this.getApi().putBlob(this.privateContainer, object);
        long now = System.currentTimeMillis();
        Date before = new Date(now - 1000000L);
        Date after = new Date(now + 1000000L);
        URI copySource = ((BlobStoreContext)this.view).getSigner().signGetBlob(this.privateContainer, "from").getEndpoint();
        try {
            this.getApi().copyBlob(copySource, this.privateContainer, "to-if-modified-since", CopyBlobOptions.builder().ifModifiedSince(after).build());
            Fail.failBecauseExceptionWasNotThrown(AzureStorageResponseException.class);
        }
        catch (AzureStorageResponseException asre) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)asre.getResponse().getStatusCode()).as("status code", new Object[0])).isEqualTo(412);
        }
        this.getApi().copyBlob(copySource, this.privateContainer, "to-if-modified-since", CopyBlobOptions.builder().ifModifiedSince(before).build());
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, "to-if-modified-since", new GetOptions[0]);
        Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)getBlob.getPayload().openStream()), (byte[])byteSource.read());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testCopyBlobIfUnmodifiedSince() throws Exception {
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("from");
        object.setPayload(byteSource.read());
        String eTag = this.getApi().putBlob(this.privateContainer, object);
        long now = System.currentTimeMillis();
        Date before = new Date(now - 1000000L);
        Date after = new Date(now + 1000000L);
        URI copySource = ((BlobStoreContext)this.view).getSigner().signGetBlob(this.privateContainer, "from").getEndpoint();
        try {
            this.getApi().copyBlob(copySource, this.privateContainer, "to-if-unmodifed-since", CopyBlobOptions.builder().ifUnmodifiedSince(before).build());
            Fail.failBecauseExceptionWasNotThrown(AzureStorageResponseException.class);
        }
        catch (AzureStorageResponseException asre) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)asre.getResponse().getStatusCode()).as("status code", new Object[0])).isEqualTo(412);
        }
        this.getApi().copyBlob(copySource, this.privateContainer, "to-if-unmodifed-since", CopyBlobOptions.builder().ifUnmodifiedSince(after).build());
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, "to-if-unmodifed-since", new GetOptions[0]);
        Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)getBlob.getPayload().openStream()), (byte[])byteSource.read());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testCopyBlobIfMatch() throws Exception {
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("from");
        object.setPayload(byteSource.read());
        String eTag = this.getApi().putBlob(this.privateContainer, object);
        String fakeETag = "0x8CEB669D794AFE2";
        URI copySource = ((BlobStoreContext)this.view).getSigner().signGetBlob(this.privateContainer, "from").getEndpoint();
        try {
            this.getApi().copyBlob(copySource, this.privateContainer, "to-if-match", CopyBlobOptions.builder().ifMatch(fakeETag).build());
            Fail.failBecauseExceptionWasNotThrown(AzureStorageResponseException.class);
        }
        catch (AzureStorageResponseException asre) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)asre.getResponse().getStatusCode()).as("status code", new Object[0])).isEqualTo(412);
        }
        this.getApi().copyBlob(copySource, this.privateContainer, "to-if-match", CopyBlobOptions.builder().ifMatch(eTag).build());
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, "to-if-match", new GetOptions[0]);
        Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)getBlob.getPayload().openStream()), (byte[])byteSource.read());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testCopyBlobIfNoneMatch() throws Exception {
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("from");
        object.setPayload(byteSource.read());
        String eTag = this.getApi().putBlob(this.privateContainer, object);
        String fakeETag = "0x8CEB669D794AFE2";
        URI copySource = ((BlobStoreContext)this.view).getSigner().signGetBlob(this.privateContainer, "from").getEndpoint();
        try {
            this.getApi().copyBlob(copySource, this.privateContainer, "to-if-none-match", CopyBlobOptions.builder().ifNoneMatch(eTag).build());
            Fail.failBecauseExceptionWasNotThrown(AzureStorageResponseException.class);
        }
        catch (AzureStorageResponseException asre) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)asre.getResponse().getStatusCode()).as("status code", new Object[0])).isEqualTo(412);
        }
        this.getApi().copyBlob(copySource, this.privateContainer, "to-if-none-match", CopyBlobOptions.builder().ifNoneMatch(fakeETag).build());
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, "to-if-none-match", new GetOptions[0]);
        Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)getBlob.getPayload().openStream()), (byte[])byteSource.read());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testSetBlobProperties() throws Exception {
        String blobName = "blob-name";
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        String contentDisposition = "attachment; filename=photo.jpg";
        String contentEncoding = "compress";
        String contentLanguage = "en";
        String contentType = "audio/ogg";
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName(blobName);
        object.setPayload(byteSource.read());
        this.getApi().putBlob(this.privateContainer, object);
        this.getApi().setBlobProperties(this.privateContainer, blobName, ContentMetadataBuilder.create().contentDisposition(contentDisposition).contentEncoding(contentEncoding).contentLanguage(contentLanguage).contentType(contentType).build());
        BlobProperties properties = this.getApi().getBlobProperties(this.privateContainer, blobName);
        ContentMetadata contentMetadata = properties.getContentMetadata();
        Assertions.assertThat((String)contentMetadata.getContentDisposition()).isEqualTo((Object)contentDisposition);
        Assertions.assertThat((String)contentMetadata.getContentEncoding()).isEqualTo((Object)contentEncoding);
        Assertions.assertThat((String)contentMetadata.getContentLanguage()).isEqualTo((Object)contentLanguage);
        Assertions.assertThat((String)contentMetadata.getContentType()).isEqualTo((Object)contentType);
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer"})
    public void testSetBlobTier() throws Exception {
        String blobName = "tier-blob-name";
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1024L);
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName(blobName);
        object.setPayload(byteSource.read());
        this.getApi().putBlob(this.privateContainer, object);
        BlobProperties properties = this.getApi().getBlobProperties(this.privateContainer, blobName);
        Assertions.assertThat((Comparable)properties.getTier()).isEqualTo((Object)AccessTier.HOT);
        this.getApi().setBlobTier(this.privateContainer, blobName, AccessTier.HOT);
        properties = this.getApi().getBlobProperties(this.privateContainer, blobName);
        Assertions.assertThat((Comparable)properties.getTier()).isEqualTo((Object)AccessTier.HOT);
        this.getApi().setBlobTier(this.privateContainer, blobName, AccessTier.COOL);
        properties = this.getApi().getBlobProperties(this.privateContainer, blobName);
        Assertions.assertThat((Comparable)properties.getTier()).isEqualTo((Object)AccessTier.COOL);
        this.getApi().setBlobTier(this.privateContainer, blobName, AccessTier.ARCHIVE);
        properties = this.getApi().getBlobProperties(this.privateContainer, blobName);
        Assertions.assertThat((Comparable)properties.getTier()).isEqualTo((Object)AccessTier.ARCHIVE);
    }
}

