/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.azure.storage.options.ListOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListOptionsTest {
    public void testIncludeMetadata() {
        ListOptions options = new ListOptions().includeMetadata();
        Assert.assertEquals((Collection)ImmutableList.of((Object)"metadata"), (Collection)options.buildQueryParameters().get((Object)"include"));
    }

    public void testIncludeMetadataStatic() {
        ListOptions options = ListOptions.Builder.includeMetadata();
        Assert.assertEquals((Collection)ImmutableList.of((Object)"metadata"), (Collection)options.buildQueryParameters().get((Object)"include"));
    }

    public void testPrefix() {
        ListOptions options = new ListOptions().prefix("a");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"a"), (Collection)options.buildQueryParameters().get((Object)"prefix"));
    }

    public void testMarker() {
        ListOptions options = new ListOptions().marker("a");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"a"), (Collection)options.buildQueryParameters().get((Object)"marker"));
    }

    public void testMaxResults() {
        int limit = 1;
        ListOptions options = new ListOptions().maxResults(limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"maxresults"));
    }

    public void testPrefixStatic() {
        ListOptions options = ListOptions.Builder.prefix((String)"a");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"a"), (Collection)options.buildQueryParameters().get((Object)"prefix"));
    }

    public void testMarkerStatic() {
        ListOptions options = ListOptions.Builder.marker((String)"a");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"a"), (Collection)options.buildQueryParameters().get((Object)"marker"));
    }

    public void testMaxResultsStatic() {
        int limit = 1;
        ListOptions options = ListOptions.Builder.maxResults((int)limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"maxresults"));
    }
}

