/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.strategy;

import java.util.List;
import org.easymock.EasyMock;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.strategy.AzureBlobBlockUploadStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.internal.BlobImpl;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.io.payloads.StringPayload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AzureBlobBlockUploadStrategyTest")
public class AzureBlobBlockUploadStrategyTest {
    public void testExecute() throws Exception {
        String container = "test-container";
        String blobName = "test-blob";
        long oneMB = 0x100000L;
        AzureBlobClient client = (AzureBlobClient)EasyMock.createMock(AzureBlobClient.class);
        PayloadSlicer slicer = (PayloadSlicer)EasyMock.createMock(PayloadSlicer.class);
        MutableBlobMetadataImpl metadata = new MutableBlobMetadataImpl();
        BaseMutableContentMetadata contentMetadata = new BaseMutableContentMetadata();
        contentMetadata.setContentLength(Long.valueOf(0xC00000L + oneMB));
        metadata.setName(blobName);
        metadata.setContentMetadata((MutableContentMetadata)contentMetadata);
        BlobImpl blob = new BlobImpl((MutableBlobMetadata)metadata);
        StringPayload payload = new StringPayload("ABCD");
        payload.setContentMetadata((MutableContentMetadata)contentMetadata);
        blob.setPayload((Payload)payload);
        EasyMock.expect((Object)slicer.slice((Payload)payload, 0L, 0x400000L)).andReturn((Object)payload);
        EasyMock.expect((Object)slicer.slice((Payload)payload, 0x400000L, 0x400000L)).andReturn((Object)payload);
        EasyMock.expect((Object)slicer.slice((Payload)payload, 0x800000L, 0x400000L)).andReturn((Object)payload);
        EasyMock.expect((Object)slicer.slice((Payload)payload, 0xC00000L, oneMB)).andReturn((Object)payload);
        client.putBlock((String)EasyMock.eq((Object)container), (String)EasyMock.eq((Object)blobName), (String)EasyMock.anyObject(String.class), (Payload)EasyMock.eq((Object)payload));
        EasyMock.expectLastCall().times(4);
        EasyMock.expect((Object)client.putBlockList((String)EasyMock.eq((Object)container), (String)EasyMock.eq((Object)blobName), (List)EasyMock.anyObject(List.class))).andReturn((Object)"Fake ETAG");
        AzureBlobBlockUploadStrategy strat = new AzureBlobBlockUploadStrategy(client, slicer);
        EasyMock.replay((Object[])new Object[]{slicer, client});
        String etag = strat.execute(container, (Blob)blob);
        Assert.assertEquals((String)etag, (String)"Fake ETAG");
    }
}

