/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import org.jclouds.azure.storage.AzureStorageResponseException;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobApiMetadata;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobBlockProperties;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.rest.RestContext;
import org.jclouds.util.Strings2;
import org.jclouds.util.Throwables2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AzureBlobClientLiveTest
extends BaseBlobStoreIntegrationTest {
    String privateContainer;
    String publicContainer;

    public AzureBlobClientLiveTest() {
        this.provider = "azureblob";
    }

    public AzureBlobClient getApi() {
        return (AzureBlobClient)((RestContext)((BlobStoreContext)this.view).unwrap(AzureBlobApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    @Test
    public void testListContainers() throws Exception {
        BoundedSet response = this.getApi().listContainers(new ListOptions[0]);
        assert (null != response);
        long initialContainerCount = response.size();
        Assert.assertTrue((initialContainerCount >= 0L ? 1 : 0) != 0);
    }

    @Test(timeOut=300000L)
    public void testCreateContainer() throws Exception {
        boolean created = false;
        while (!created) {
            this.privateContainer = this.prefix + new SecureRandom().nextInt();
            try {
                created = this.getApi().createContainer(this.privateContainer, new CreateContainerOptions[]{CreateContainerOptions.Builder.withMetadata((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"bar"))});
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 409) continue;
                throw e;
            }
        }
        BoundedSet response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.includeMetadata()});
        assert (null != response);
        long containerCount = response.size();
        Assert.assertTrue((containerCount >= 1L ? 1 : 0) != 0);
        ListBlobsResponse list = this.getApi().listBlobs(this.privateContainer, new ListBlobsOptions[0]);
        Assert.assertEquals((Object)list.getUrl(), (Object)URI.create(String.format("https://%s.blob.core.windows.net/%s", ((RestContext)((BlobStoreContext)this.view).unwrap(AzureBlobApiMetadata.CONTEXT_TOKEN)).getIdentity(), this.privateContainer)));
    }

    @Test(timeOut=300000L)
    public void testCreatePublicContainer() throws Exception {
        boolean created = false;
        while (!created) {
            this.publicContainer = this.prefix + new SecureRandom().nextInt();
            try {
                created = this.getApi().createContainer(this.publicContainer, new CreateContainerOptions[]{CreateContainerOptions.Builder.withPublicAccess((PublicAccess)PublicAccess.BLOB)});
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 409) continue;
                throw e;
            }
        }
    }

    @Test(timeOut=600000L)
    public void testCreatePublicRootContainer() throws Exception {
        try {
            this.getApi().deleteRootContainer();
        }
        catch (ContainerNotFoundException e) {
            Thread.sleep(5000L);
        }
        catch (AzureStorageResponseException htpe) {
            if (htpe.getResponse().getStatusCode() == 409) {
                Thread.sleep(5000L);
            }
            throw htpe;
        }
        boolean created = false;
        while (!created) {
            try {
                created = this.getApi().createRootContainer(new CreateContainerOptions[0]);
            }
            catch (AzureStorageResponseException htpe) {
                if (htpe.getResponse().getStatusCode() == 409) {
                    Thread.sleep(5000L);
                    continue;
                }
                throw htpe;
            }
        }
        ListBlobsResponse list = this.getApi().listBlobs(new ListBlobsOptions[0]);
        Assert.assertEquals((Object)list.getUrl(), (Object)URI.create(String.format("https://%s.blob.core.windows.net/$root", ((RestContext)((BlobStoreContext)this.view).unwrap(AzureBlobApiMetadata.CONTEXT_TOKEN)).getIdentity())));
    }

    @Test
    public void testListContainersWithOptions() throws Exception {
        BoundedSet response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.prefix((String)this.privateContainer).maxResults(1).includeMetadata()});
        assert (null != response);
        long initialContainerCount = response.size();
        Assert.assertTrue((initialContainerCount >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)this.privateContainer, (String)response.getPrefix());
        Assert.assertEquals((int)1, (int)response.getMaxResults());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreatePublicRootContainer"})
    public void testDeleteRootContainer() throws Exception {
        this.getApi().deleteRootContainer();
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer", "testCreatePublicContainer"})
    public void testListOwnedContainers() throws Exception {
        BoundedSet response = this.getApi().listContainers(new ListOptions[0]);
        response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.prefix((String)this.privateContainer.substring(0, this.privateContainer.length() - 1)).maxResults(1).includeMetadata()});
        Assert.assertEquals((int)response.size(), (int)1);
        Assert.assertEquals((String)((ContainerProperties)Iterables.getOnlyElement((Iterable)response)).getName(), (String)this.privateContainer);
        Assert.assertEquals((Map)((ContainerProperties)Iterables.getOnlyElement((Iterable)response)).getMetadata(), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        response = this.getApi().listContainers(new ListOptions[]{ListOptions.Builder.prefix((String)this.publicContainer).maxResults(1)});
        Assert.assertEquals((int)response.size(), (int)1);
        Assert.assertEquals((String)((ContainerProperties)Iterables.getOnlyElement((Iterable)response)).getName(), (String)this.publicContainer);
    }

    @Test
    public void testDeleteOneContainer() throws Exception {
        this.getApi().deleteContainer("does-not-exist");
    }

    @Test(timeOut=300000L, dependsOnMethods={"testListOwnedContainers", "testObjectOperations"})
    public void testDeleteContainer() throws Exception {
        this.getApi().deleteContainer(this.privateContainer);
        this.getApi().deleteContainer(this.publicContainer);
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateContainer", "testCreatePublicContainer"})
    public void testObjectOperations() throws Exception {
        String data = "Here is my data";
        AzureBlob object = this.getApi().newBlob();
        object.getProperties().setName("object");
        object.setPayload(data);
        Payloads.calculateMD5((PayloadEnclosing)object);
        object.getProperties().getContentMetadata().setContentType("text/plain");
        object.getProperties().getMetadata().put("mykey", "metadata-value");
        byte[] md5 = object.getProperties().getContentMetadata().getContentMD5();
        String newEtag = this.getApi().putBlob(this.privateContainer, object);
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(md5), (String)BaseEncoding.base16().lowerCase().encode(object.getProperties().getContentMetadata().getContentMD5()));
        assert (this.getApi().getBlobProperties(this.privateContainer, "non-existent-object") == null);
        BlobProperties metadata = this.getApi().getBlobProperties(this.privateContainer, object.getProperties().getName());
        Assert.assertEquals((String)metadata.getContentMetadata().getContentType(), (String)"text/plain");
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(md5), (String)BaseEncoding.base16().lowerCase().encode(object.getProperties().getContentMetadata().getContentMD5()));
        Assert.assertEquals((String)metadata.getETag(), (String)newEtag);
        Assert.assertEquals((int)metadata.getMetadata().entrySet().size(), (int)1);
        Assert.assertEquals((String)((String)metadata.getMetadata().get("mykey")), (String)"metadata-value");
        assert (this.getApi().getBlob(this.privateContainer, "non-existent-object", new GetOptions[0]) == null);
        AzureBlob getBlob = this.getApi().getBlob(this.privateContainer, object.getProperties().getName(), new GetOptions[0]);
        Assert.assertEquals((String)Strings2.toString((InputSupplier)getBlob.getPayload()), (String)data);
        Assert.assertEquals((Object)getBlob.getPayload().getContentMetadata().getContentLength(), (Object)data.length());
        Assert.assertEquals((String)getBlob.getProperties().getContentMetadata().getContentType(), (String)"text/plain");
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(md5), (String)BaseEncoding.base16().lowerCase().encode(getBlob.getProperties().getContentMetadata().getContentMD5()));
        Assert.assertEquals((String)newEtag, (String)getBlob.getProperties().getETag());
        Assert.assertEquals((int)metadata.getMetadata().entrySet().size(), (int)1);
        Assert.assertEquals((String)((String)metadata.getMetadata().get("mykey")), (String)"metadata-value");
        ListBlobsResponse response = this.getApi().listBlobs(this.privateContainer, new ListBlobsOptions[]{ListBlobsOptions.Builder.prefix((String)object.getProperties().getName().substring(0, object.getProperties().getName().length() - 1)).maxResults(1).includeMetadata()});
        Assert.assertEquals((int)response.size(), (int)1);
        Assert.assertEquals((String)((BlobProperties)Iterables.getOnlyElement((Iterable)response)).getName(), (String)object.getProperties().getName());
        Assert.assertEquals((Map)((BlobProperties)Iterables.getOnlyElement((Iterable)response)).getMetadata(), (Map)ImmutableMap.of((Object)"mykey", (Object)"metadata-value"));
        String correctEtag = newEtag;
        String incorrectEtag = "0" + correctEtag.substring(1);
        object.getProperties().setETag(incorrectEtag);
        try {
            this.getApi().putBlob(this.privateContainer, object);
        }
        catch (Throwable e) {
            Assert.assertEquals(e.getCause().getClass(), HttpResponseException.class);
            Assert.assertEquals((int)((HttpResponseException)e.getCause()).getResponse().getStatusCode(), (int)422);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes(Charsets.UTF_8));
        object = this.getApi().newBlob();
        object.getProperties().setName("chunked-object");
        object.setPayload((InputStream)bais);
        object.getPayload().getContentMetadata().setContentLength(Long.valueOf(data.getBytes().length));
        newEtag = this.getApi().putBlob(this.privateContainer, object);
        Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(md5), (String)BaseEncoding.base16().lowerCase().encode(getBlob.getProperties().getContentMetadata().getContentMD5()));
        try {
            this.getApi().getBlob(this.privateContainer, object.getProperties().getName(), new GetOptions[]{GetOptions.Builder.ifETagDoesntMatch((String)newEtag)});
        }
        catch (Exception e) {
            HttpResponseException httpEx = (HttpResponseException)Throwables2.getFirstThrowableOfType((Throwable)e, HttpResponseException.class);
            assert (httpEx != null) : "expected http exception, not " + e;
            Assert.assertEquals((int)httpEx.getResponse().getStatusCode(), (int)304);
        }
        try {
            getBlob = this.getApi().getBlob(this.privateContainer, object.getProperties().getName(), new GetOptions[]{GetOptions.Builder.ifETagMatches((String)newEtag)});
            Assert.assertEquals((String)getBlob.getProperties().getETag(), (String)newEtag);
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)412);
        }
        this.getApi().deleteBlob(this.privateContainer, "object");
        this.getApi().deleteBlob(this.privateContainer, "chunked-object");
    }

    @Test(timeOut=300000L)
    public void testBlockOperations() throws Exception {
        String blockContainer = this.prefix + new SecureRandom().nextInt();
        String blockBlob = "myblockblob-" + new SecureRandom().nextInt();
        String A = "A";
        String B = "B";
        String C = "C";
        String blockIdA = BaseEncoding.base64().encode((blockBlob + "-" + A).getBytes());
        String blockIdB = BaseEncoding.base64().encode((blockBlob + "-" + B).getBytes());
        String blockIdC = BaseEncoding.base64().encode((blockBlob + "-" + C).getBytes());
        this.getApi().createContainer(blockContainer, new CreateContainerOptions[0]);
        this.getApi().putBlock(blockContainer, blockBlob, blockIdA, (Payload)new ByteArrayPayload(A.getBytes()));
        this.getApi().putBlock(blockContainer, blockBlob, blockIdB, (Payload)new ByteArrayPayload(B.getBytes()));
        this.getApi().putBlock(blockContainer, blockBlob, blockIdC, (Payload)new ByteArrayPayload(C.getBytes()));
        this.getApi().putBlockList(blockContainer, blockBlob, Arrays.asList(blockIdA, blockIdB, blockIdC));
        ListBlobBlocksResponse blocks = this.getApi().getBlockList(blockContainer, blockBlob);
        Assert.assertEquals((int)3, (int)blocks.getBlocks().size());
        Assert.assertEquals((String)blockIdA, (String)((BlobBlockProperties)blocks.getBlocks().get(0)).getBlockName());
        Assert.assertEquals((String)blockIdB, (String)((BlobBlockProperties)blocks.getBlocks().get(1)).getBlockName());
        Assert.assertEquals((String)blockIdC, (String)((BlobBlockProperties)blocks.getBlocks().get(2)).getBlockName());
        Assert.assertEquals((long)1L, (long)((BlobBlockProperties)blocks.getBlocks().get(0)).getContentLength());
        Assert.assertEquals((long)1L, (long)((BlobBlockProperties)blocks.getBlocks().get(1)).getContentLength());
        Assert.assertEquals((long)1L, (long)((BlobBlockProperties)blocks.getBlocks().get(2)).getContentLength());
        this.getApi().deleteContainer(blockContainer);
    }
}

