/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobAsyncClient;
import org.jclouds.azureblob.AzureBlobFallbacks;
import org.jclouds.azureblob.AzureBlobProviderMetadata;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.functions.ParseBlobFromHeadersAndHttpContent;
import org.jclouds.azureblob.functions.ParseContainerPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParsePublicAccessHeader;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.azureblob.xml.AccountNameEnumerationResultsHandler;
import org.jclouds.azureblob.xml.ContainerNameEnumerationResultsHandler;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AzureBlobAsyncClientTest")
public class AzureBlobAsyncClientTest
extends BaseAsyncClientTest<AzureBlobAsyncClient> {
    public void testListContainers() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"listContainers", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/?comp=list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AccountNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testListContainersOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"listContainers", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.maxResults((int)1).marker("marker").prefix("prefix")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/?comp=list&maxresults=1&marker=marker&prefix=prefix HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AccountNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testCreateContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"createContainer", (Class[])new Class[]{String.class, CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testDeleteContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"deleteContainer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
    }

    public void testCreateContainerOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"createContainer", (Class[])new Class[]{String.class, CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)CreateContainerOptions.Builder.withPublicAccess((PublicAccess)PublicAccess.BLOB).withMetadata((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"bar"))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-blob-public-access: blob\nx-ms-meta-foo: bar\nx-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testCreateRootContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"createRootContainer", (Class[])new Class[]{CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/$root?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testDeleteRootContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"deleteRootContainer", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://identity.blob.core.windows.net/$root?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.TrueOnNotFoundOr404.class);
    }

    public void testCreateRootContainerOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"createRootContainer", (Class[])new Class[]{CreateContainerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)CreateContainerOptions.Builder.withPublicAccess((PublicAccess)PublicAccess.BLOB).withMetadata((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"bar"))));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/$root?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-blob-public-access: blob\nx-ms-meta-foo: bar\nx-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, AzureBlobFallbacks.FalseIfContainerAlreadyExists.class);
    }

    public void testListBlobs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"listBlobs", (Class[])new Class[]{String.class, ListBlobsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/container?restype=container&comp=list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ContainerNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testListRootBlobs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"listBlobs", (Class[])new Class[]{ListBlobsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/$root?restype=container&comp=list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ContainerNameEnumerationResultsHandler.class);
        this.assertFallbackClassEquals(method, null);
    }

    public void testContainerProperties() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"getContainerProperties", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://identity.blob.core.windows.net/container?restype=container HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseContainerPropertiesFromHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnContainerNotFound.class);
    }

    public void testGetPublicAccessForContainer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"getPublicAccessForContainer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://identity.blob.core.windows.net/container?restype=container&comp=acl HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParsePublicAccessHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnContainerNotFound.class);
    }

    public void testSetResourceMetadata() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"setResourceMetadata", (Class[])new Class[]{String.class, Map.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)ImmutableMap.of((Object)"key", (Object)"value")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container?restype=container&comp=metadata HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-meta-key: value\nx-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    public void testGetBlob() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"getBlob", (Class[])new Class[]{String.class, String.class, GetOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)"blob"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://identity.blob.core.windows.net/container/blob HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseBlobFromHeadersAndHttpContent.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnKeyNotFound.class);
    }

    public void testSetBlobMetadata() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AzureBlobAsyncClient.class, (String)"setBlobMetadata", (Class[])new Class[]{String.class, String.class, Map.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"container", (Object)"blob", (Object)ImmutableMap.of((Object)"key", (Object)"value")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://identity.blob.core.windows.net/container/blob?comp=metadata HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "x-ms-meta-key: value\nx-ms-version: 2009-09-19\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SharedKeyLiteAuthentication.class);
    }

    public AzureBlobProviderMetadata createProviderMetadata() {
        return new AzureBlobProviderMetadata();
    }
}

