/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.jclouds.http.BaseMockWebServerTest;
import org.jclouds.http.okhttp.config.OkHttpCommandExecutorServiceModule;
import org.jclouds.util.Strings2;

public class BaseDockerMockTest
extends BaseMockWebServerTest {
    protected static final String API_VERSION = "1.15";

    protected void addOverrideProperties(Properties properties) {
        properties.setProperty("jclouds.api-version", API_VERSION);
    }

    protected Module createConnectionModule() {
        return new OkHttpCommandExecutorServiceModule();
    }

    public byte[] payloadFromResource(String resource) {
        try {
            return Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resource)).getBytes(Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected RecordedRequest assertSent(MockWebServer server, String method, String path) throws InterruptedException {
        RecordedRequest request = server.takeRequest();
        Assertions.assertThat((String)request.getMethod()).isEqualTo((Object)method);
        Assertions.assertThat((String)request.getPath()).isEqualTo((Object)("/v1.15" + path));
        Assertions.assertThat((String)request.getHeader("Accept")).isEqualTo((Object)"application/json");
        return request;
    }
}

