/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.BaseDockerApiLiveTest;
import org.jclouds.docker.features.MiscApi;
import org.jclouds.docker.internal.BaseDockerMockTest;
import org.jclouds.docker.parse.InfoParseTest;
import org.jclouds.docker.parse.VersionParseTest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MiscApiMockTest")
public class MiscApiMockTest
extends BaseDockerMockTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetVersion() throws Exception {
        MockWebServer server = MiscApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/version.json"))});
        MiscApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getMiscApi();
        try {
            Assert.assertEquals((Object)api.getVersion(), (Object)new VersionParseTest().expected());
            this.assertSent(server, "GET", "/version");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInfo() throws Exception {
        MockWebServer server = MiscApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/info.json"))});
        MiscApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getMiscApi();
        try {
            Assert.assertEquals((Object)api.getInfo(), (Object)new InfoParseTest().expected());
            this.assertSent(server, "GET", "/info");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBuildContainer() throws Exception {
        MockWebServer server = MiscApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(200)});
        MiscApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getMiscApi();
        try {
            api.build(BaseDockerApiLiveTest.tarredDockerfile());
            this.assertSent(server, "POST", "/build");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBuildContainerUsingPayload() throws Exception {
        MockWebServer server = MiscApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(200)});
        MiscApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getMiscApi();
        File file = File.createTempFile("docker", "tmp");
        FileInputStream data = new FileInputStream(file);
        InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)data);
        payload.getContentMetadata().setContentLength(Long.valueOf(file.length()));
        try {
            api.build((Payload)payload);
            this.assertSent(server, "POST", "/build");
        }
        finally {
            server.shutdown();
        }
    }
}

