/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.BaseDockerApiLiveTest;
import org.jclouds.docker.features.MiscApi;
import org.jclouds.docker.options.BuildOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="MiscApiLiveTest", singleThreaded=true)
public class MiscApiLiveTest
extends BaseDockerApiLiveTest {
    private static final String API_VERSION = "1.16";
    private static final String VERSION = "1.4.1";
    private static final String GIT_COMMIT = "5bc2ff8";
    private static final String GO_VERSION = "go1.3.3";
    private static final String KERNEL_VERSION = "3.16.7-tinycore64";
    private static final String ARCH = "amd64";
    private static final String OS = "linux";
    private static String imageId;

    @Test
    public void testVersion() {
        Assert.assertEquals((String)this.api().getVersion().apiVersion(), (String)API_VERSION);
        Assert.assertEquals((String)this.api().getVersion().version(), (String)VERSION);
        Assert.assertEquals((String)this.api().getVersion().gitCommit(), (String)GIT_COMMIT);
        Assert.assertEquals((String)this.api().getVersion().goVersion(), (String)GO_VERSION);
        Assert.assertEquals((String)this.api().getVersion().kernelVersion(), (String)KERNEL_VERSION);
        Assert.assertEquals((String)this.api().getVersion().arch(), (String)ARCH);
        Assert.assertEquals((String)this.api().getVersion().os(), (String)OS);
    }

    @Test
    public void testInfo() {
        Assert.assertNotNull((Object)this.api().getInfo());
    }

    @Test
    public void testBuildImageFromDockerfile() throws IOException, InterruptedException, URISyntaxException {
        BuildOptions options = BuildOptions.Builder.tag((String)"testBuildImage").verbose(Boolean.valueOf(false)).nocache(Boolean.valueOf(false));
        InputStream buildImageStream = this.api().build(MiscApiLiveTest.tarredDockerfile(), options);
        String buildStream = this.consumeStream(buildImageStream);
        Iterable splitted = Splitter.on((String)"\n").split((CharSequence)buildStream.replace("\r", "").trim());
        String lastStreamedLine = ((String)Iterables.getLast((Iterable)splitted)).trim();
        String rawImageId = (String)Iterables.getLast((Iterable)Splitter.on((String)"Successfully built ").split((CharSequence)lastStreamedLine));
        imageId = rawImageId.substring(0, 11);
        Assert.assertNotNull((Object)imageId);
    }

    private MiscApi api() {
        return ((DockerApi)this.api).getMiscApi();
    }
}

