/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.Collection;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.config.DockerParserModule;
import org.jclouds.docker.features.ImageApi;
import org.jclouds.docker.internal.BaseDockerMockTest;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.parse.ImageParseTest;
import org.jclouds.docker.parse.ImagesParseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ImageApiMockTest")
public class ImageApiMockTest
extends BaseDockerMockTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(200)});
        ImageApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getImageApi();
        try {
            api.createImage(CreateImageOptions.Builder.fromImage((String)"base"));
            this.assertSent(server, "POST", "/images/create?fromImage=base");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/image.json"))});
        ImageApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString(), new Module[]{new DockerParserModule()})).getImageApi();
        try {
            String imageId = "cbba6639a342646deed70d7ea6162fa2a0acea9300f911f4e014555fe37d3456";
            Assert.assertEquals((Object)api.inspectImage(imageId), (Object)new ImageParseTest().expected());
            this.assertSent(server, "GET", "/images/" + imageId + "/json");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListImages() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/images.json"))});
        ImageApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getImageApi();
        try {
            Assert.assertEquals((Collection)api.listImages(), (Collection)new ImagesParseTest().expected());
            this.assertSent(server, "GET", "/images/json");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(204)});
        ImageApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getImageApi();
        try {
            api.deleteImage("1");
            this.assertSent(server, "DELETE", "/images/1");
        }
        finally {
            server.shutdown();
        }
    }
}

