/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import java.io.InputStream;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.BaseDockerApiLiveTest;
import org.jclouds.docker.features.ImageApi;
import org.jclouds.docker.options.CreateImageOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="RemoteApiLiveTest", singleThreaded=true)
public class ImageApiLiveTest
extends BaseDockerApiLiveTest {
    private static final String DEFAULT_IMAGE = "busybox";
    private static final String DEFAULT_TAG = "ubuntu-14.04";

    @Test
    public void testCreateImage() {
        InputStream createImageStream = this.api().createImage(CreateImageOptions.Builder.fromImage((String)DEFAULT_IMAGE).tag(DEFAULT_TAG));
        this.consumeStream(createImageStream);
    }

    @Test(dependsOnMethods={"testCreateImage"})
    public void testInspectImage() {
        Assert.assertNotNull((Object)((DockerApi)this.api).getImageApi().inspectImage(String.format("%s:%s", DEFAULT_IMAGE, DEFAULT_TAG)));
    }

    @Test(dependsOnMethods={"testInspectImage"})
    public void testListImages() {
        Assert.assertNotNull((Object)this.api().listImages());
    }

    @Test(dependsOnMethods={"testListImages"})
    public void testDeleteImage() {
        this.consumeStream(this.api().deleteImage(String.format("%s:%s", DEFAULT_IMAGE, DEFAULT_TAG)));
        Assert.assertNull((Object)this.api().inspectImage(String.format("%s:%s", DEFAULT_IMAGE, DEFAULT_TAG)));
    }

    private ImageApi api() {
        return ((DockerApi)this.api).getImageApi();
    }
}

