/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.config.DockerParserModule;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.Resource;
import org.jclouds.docker.features.ContainerApi;
import org.jclouds.docker.internal.BaseDockerMockTest;
import org.jclouds.docker.options.ListContainerOptions;
import org.jclouds.docker.parse.ContainerParseTest;
import org.jclouds.docker.parse.ContainersParseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ContainerApiMockTest")
public class ContainerApiMockTest
extends BaseDockerMockTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListContainers() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/containers.json"))});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            Assert.assertEquals((Collection)api.listContainers(), (Collection)new ContainersParseTest().expected());
            this.assertSent(server, "GET", "/containers/json");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListNonexistentContainers() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(404)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            Assert.assertEquals((Collection)api.listContainers(), (Collection)ImmutableList.of());
            this.assertSent(server, "GET", "/containers/json");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=10000L)
    public void testListAllContainers() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/containers.json"))});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            Assert.assertEquals((Collection)api.listContainers(ListContainerOptions.Builder.all((Boolean)true)), (Collection)new ContainersParseTest().expected());
            this.assertSent(server, "GET", "/containers/json?all=true");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/container.json"))});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString(), new Module[]{new DockerParserModule()})).getContainerApi();
        String containerId = "b03d4cd15b76f8876110615cdeed15eadf77c9beb408d62f1687dcc69192cd6d";
        try {
            Assert.assertEquals((Object)api.inspectContainer(containerId), (Object)new ContainerParseTest().expected());
            this.assertSent(server, "GET", "/containers/" + containerId + "/json");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setBody(this.payloadFromResource("/container-creation.json"))});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        Config containerConfig = Config.builder().cmd((List)ImmutableList.of((Object)"date")).attachStdin(false).attachStderr(true).attachStdout(true).tty(false).image("base").build();
        try {
            Container container = api.createContainer("test", containerConfig);
            this.assertSent(server, "POST", "/containers/create?name=test");
            Assert.assertNotNull((Object)container);
            Assertions.assertThat((String)container.id()).isEqualTo((Object)"c6c74153ae4b1d1633d68890a68d89c40aa5e284a1ea016cbc6ef0e634ee37b2");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(204)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        String containerId = "6d35806c1bd2b25cd92bba2d2c2c5169dc2156f53ab45c2b62d76e2d2fee14a9";
        try {
            api.removeContainer(containerId);
            this.assertSent(server, "DELETE", "/containers/" + containerId);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(200)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.startContainer("1");
            this.assertSent(server, "POST", "/containers/1/start");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStopContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(200)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.stopContainer("1");
            this.assertSent(server, "POST", "/containers/1/stop");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommitContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(201)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.commit();
            this.assertSent(server, "POST", "/commit");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPauseContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(204)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.pause("1");
            this.assertSent(server, "POST", "/containers/1/pause");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnpauseContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(204)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.unpause("1");
            this.assertSent(server, "POST", "/containers/1/unpause");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(200)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.attach("1");
            this.assertSent(server, "POST", "/containers/1/attach");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWaitContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(200)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.wait("1");
            this.assertSent(server, "POST", "/containers/1/wait");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestartContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(204)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.restart("1");
            this.assertSent(server, "POST", "/containers/1/restart");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKillContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(204)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.kill("1");
            this.assertSent(server, "POST", "/containers/1/kill");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFileFromContainer() throws Exception {
        MockWebServer server = ContainerApiMockTest.mockWebServer((MockResponse[])new MockResponse[]{new MockResponse().setResponseCode(204)});
        ContainerApi api = ((DockerApi)this.api(DockerApi.class, server.getUrl("/").toString())).getContainerApi();
        try {
            api.copy("1", Resource.create((String)"test"));
            this.assertSent(server, "POST", "/containers/1/copy");
        }
        finally {
            server.shutdown();
        }
    }
}

