/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.BaseDockerApiLiveTest;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.ContainerSummary;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.domain.Resource;
import org.jclouds.docker.features.ContainerApi;
import org.jclouds.docker.options.AttachOptions;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.options.ListContainerOptions;
import org.jclouds.docker.options.RemoveContainerOptions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="RemoteApiLiveTest", singleThreaded=true)
public class ContainerApiLiveTest
extends BaseDockerApiLiveTest {
    private Container container = null;
    protected static final String BUSYBOX_IMAGE_TAG = "busybox:ubuntu-12.04";
    protected Image image = null;

    @BeforeClass
    protected void init() {
        if (((DockerApi)this.api).getImageApi().inspectImage(BUSYBOX_IMAGE_TAG) == null) {
            CreateImageOptions options = CreateImageOptions.Builder.fromImage((String)BUSYBOX_IMAGE_TAG);
            InputStream createImageStream = ((DockerApi)this.api).getImageApi().createImage(options);
            this.consumeStream(createImageStream);
        }
        this.image = ((DockerApi)this.api).getImageApi().inspectImage(BUSYBOX_IMAGE_TAG);
        Assert.assertNotNull((Object)this.image);
    }

    @AfterClass
    protected void tearDown() {
        if (this.container != null && ((DockerApi)this.api).getContainerApi().inspectContainer(this.container.id()) != null) {
            ((DockerApi)this.api).getContainerApi().removeContainer(this.container.id(), RemoveContainerOptions.Builder.force((Boolean)true));
        }
        if (this.image != null) {
            ((DockerApi)this.api).getImageApi().deleteImage(BUSYBOX_IMAGE_TAG);
        }
    }

    public void testCreateContainer() throws IOException, InterruptedException {
        Config containerConfig = Config.builder().image(this.image.id()).cmd((List)ImmutableList.of((Object)"/bin/sh", (Object)"-c", (Object)"touch hello; while true; do echo hello world; sleep 1; done")).build();
        this.container = this.api().createContainer("testCreateContainer", containerConfig);
        Assert.assertNotNull((Object)this.container);
        Assert.assertNotNull((Object)this.container.id());
    }

    @Test(dependsOnMethods={"testCreateContainer"})
    public void testStartContainer() throws IOException, InterruptedException {
        this.api().startContainer(this.container.id());
        Assert.assertTrue((boolean)this.api().inspectContainer(this.container.id()).state().running());
    }

    @Test(dependsOnMethods={"testStartContainer"})
    public void testAttachContainer() {
        InputStream attachStream = this.api().attach(this.container.id(), AttachOptions.Builder.logs((Boolean)true).stream(Boolean.valueOf(false)).stdout(Boolean.valueOf(true)));
        String stream = this.consumeStream(attachStream);
        Assertions.assertThat((String)stream.trim()).contains(new CharSequence[]{"hello world"});
    }

    @Test(dependsOnMethods={"testAttachContainer"})
    public void testCopyFileFromContainer() {
        InputStream tarredStream = this.api().copy(this.container.id(), Resource.create((String)"hello"));
        Assert.assertNotNull((Object)this.consumeStream(tarredStream));
    }

    @Test(dependsOnMethods={"testCopyFileFromContainer"})
    public void testPauseContainer() {
        this.api().pause(this.container.id());
        Assert.assertTrue((boolean)this.api().inspectContainer(this.container.id()).state().paused());
    }

    @Test(dependsOnMethods={"testPauseContainer"})
    public void testUnpauseContainer() {
        this.api().unpause(this.container.id());
        Assert.assertFalse((boolean)this.api().inspectContainer(this.container.id()).state().paused());
    }

    @Test(dependsOnMethods={"testUnpauseContainer"})
    public void testStopContainer() {
        this.api().stopContainer(this.container.id());
        Assert.assertFalse((boolean)this.api().inspectContainer(this.container.id()).state().running());
    }

    @Test(dependsOnMethods={"testStopContainer"})
    public void testRestartContainer() {
        this.api().restart(this.container.id());
        Assert.assertTrue((boolean)this.api().inspectContainer(this.container.id()).state().running());
    }

    @Test(dependsOnMethods={"testRestartContainer"})
    public void testWaitContainer() {
        this.api().stopContainer(this.container.id(), 1);
        Assert.assertEquals((int)this.api().wait(this.container.id()).statusCode(), (int)-1);
    }

    @Test(dependsOnMethods={"testWaitContainer"})
    public void testRemoveContainer() {
        this.api().removeContainer(this.container.id());
        Assert.assertNull((Object)this.api().inspectContainer(this.container.id()));
    }

    @Test
    public void testListContainers() {
        List containerSummaries = this.api().listContainers(ListContainerOptions.Builder.all((Boolean)true));
        for (ContainerSummary containerSummary : containerSummaries) {
            Assert.assertNotNull((Object)containerSummary.id());
            Assert.assertNotNull((Object)containerSummary.image());
            Assert.assertFalse((boolean)containerSummary.names().isEmpty());
        }
    }

    private ContainerApi api() {
        return ((DockerApi)this.api).getContainerApi();
    }
}

