/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import org.jclouds.docker.config.DockerParserModule;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.NetworkSettings;
import org.jclouds.docker.domain.Port;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DockerParserModuleTest")
public class DockerParserModuleTest {
    private Json json = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule(), new DockerParserModule()}).getInstance(Json.class);

    public void testContainerWithVolumesNull() {
        Container container = (Container)this.json.fromJson("{ \"Id\": \"foo\", \"Volumes\": null }", Container.class);
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((String)container.id(), (String)"foo");
        Assert.assertEquals((Map)container.volumes(), (Map)ImmutableMap.of());
    }

    public void port() {
        String text = "{\"IP\":\"0.0.0.0\",\"PrivatePort\":4567,\"PublicPort\":49155,\"Type\":\"tcp\"}";
        Port port = Port.create((String)"0.0.0.0", (int)4567, (int)49155, (String)"tcp");
        Assert.assertEquals((Object)this.json.fromJson(text, Port.class), (Object)port);
        Assert.assertEquals((String)this.json.toJson((Object)port), (String)text);
    }

    public void networkSettings() {
        String text = "{\"IPAddress\":\"XX.XX.206.98\",\"IPPrefixLen\":27,\"Gateway\":\"XX.XX.206.105\",\"Bridge\":\"public\",\"Ports\":{}}";
        NetworkSettings settings = NetworkSettings.create((String)"XX.XX.206.98", (int)27, (String)"XX.XX.206.105", (String)"public", null, null);
        Assert.assertEquals((Object)this.json.fromJson(text, NetworkSettings.class), (Object)settings);
        Assert.assertEquals((String)this.json.toJson((Object)settings), (String)text);
    }
}

