/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import org.easymock.EasyMock;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.docker.compute.functions.StateToStatus;
import org.jclouds.docker.domain.State;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="StateToStatusTest")
public class StateToStatusTest {
    private StateToStatus function;

    @BeforeMethod
    public void setup() {
        this.function = new StateToStatus();
    }

    public void testStateRunningToStatusRunning() {
        State mockState = this.mockStateRunning();
        NodeMetadata.Status status = this.function.apply(mockState);
        EasyMock.verify((Object[])new Object[]{mockState});
        Assert.assertEquals((boolean)mockState.running(), (boolean)true);
        Assert.assertEquals((Object)status, (Object)NodeMetadata.Status.RUNNING);
    }

    public void testStateNotRunningToStatusTerminated() {
        State mockState = this.mockStateNotRunning();
        NodeMetadata.Status status = this.function.apply(mockState);
        EasyMock.verify((Object[])new Object[]{mockState});
        Assert.assertEquals((boolean)mockState.running(), (boolean)false);
        Assert.assertEquals((Object)status, (Object)NodeMetadata.Status.TERMINATED);
    }

    private State mockStateRunning() {
        State mockState = (State)EasyMock.createMock(State.class);
        EasyMock.expect((Object)mockState.running()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockState});
        return mockState;
    }

    private State mockStateNotRunning() {
        State mockState = (State)EasyMock.createMock(State.class);
        EasyMock.expect((Object)mockState.running()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockState});
        return mockState;
    }
}

