/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.docker.compute.functions.ImageToImage;
import org.jclouds.docker.domain.Config;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ImageToImageTest")
public class ImageToImageTest {
    private ImageToImage function;
    private org.jclouds.docker.domain.Image image;

    @BeforeMethod
    public void setup() {
        this.image = org.jclouds.docker.domain.Image.create((String)"id", (String)"author", (String)"comment", (Config)Config.builder().image("imageId").build(), (Config)Config.builder().image("imageId").build(), (String)"parent", (Date)new Date(), (String)"containerId", (String)"1.3.1", (String)"x86_64", (String)"os", (long)0L, (long)0L, (List)ImmutableList.of((Object)"repoTag1:version"));
        this.function = new ImageToImage();
    }

    public void testImageToImage() {
        org.jclouds.docker.domain.Image mockImage = this.mockImage();
        Image image = this.function.apply(mockImage);
        EasyMock.verify((Object[])new Object[]{mockImage});
        Assert.assertEquals((String)mockImage.id(), (String)image.getId().toString());
    }

    private org.jclouds.docker.domain.Image mockImage() {
        org.jclouds.docker.domain.Image mockImage = (org.jclouds.docker.domain.Image)EasyMock.createMock(org.jclouds.docker.domain.Image.class);
        EasyMock.expect((Object)mockImage.id()).andReturn((Object)this.image.id()).anyTimes();
        EasyMock.expect((Object)mockImage.repoTags()).andReturn((Object)this.image.repoTags()).anyTimes();
        EasyMock.expect((Object)mockImage.architecture()).andReturn((Object)this.image.architecture()).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockImage});
        return mockImage;
    }
}

