/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.docker.compute.functions.ContainerToNodeMetadata;
import org.jclouds.docker.compute.functions.StateToStatus;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.domain.NetworkSettings;
import org.jclouds.docker.domain.State;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.providers.ProviderMetadata;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ContainerToNodeMetadataTest")
public class ContainerToNodeMetadataTest {
    private LoginCredentials credentials;
    private ContainerToNodeMetadata function;
    private Container container;

    @BeforeMethod
    public void setup() {
        Config containerConfig = Config.builder().hostname("6d35806c1bd2").domainname("").user("").memory(0).memorySwap(0).cpuShares(0).attachStdin(false).attachStdout(false).attachStderr(false).exposedPorts((Map)ImmutableMap.of((Object)"22/tcp", (Object)ImmutableMap.of())).tty(false).openStdin(false).stdinOnce(false).env(null).cmd((List)ImmutableList.of((Object)"/usr/sbin/sshd", (Object)"-D")).image("jclouds/ubuntu").volumesFrom("").workingDir("").entrypoint(null).networkDisabled(false).build();
        State state = State.create((int)3626, (boolean)true, (int)0, (String)"2014-03-24T20:28:37.537659054Z", (String)"0001-01-01T00:00:00Z", (boolean)false, (boolean)false);
        this.container = Container.builder().id("6d35806c1bd2b25cd92bba2d2c2c5169dc2156f53ab45c2b62d76e2d2fee14a9").name("/hopeful_mclean").created(new SimpleDateFormatDateService().iso8601DateParse("2014-03-22T07:16:45.784120972Z")).path("/usr/sbin/sshd").args(Arrays.asList("-D")).config(containerConfig).state(state).image("af0f59f1c19eef9471c3b8c8d587c39b8f130560b54f3766931b37d76d5de4b6").networkSettings(NetworkSettings.builder().ipAddress("172.17.0.2").ipPrefixLen(16).gateway("172.17.42.1").bridge("docker0").ports((Map)ImmutableMap.of((Object)"22/tcp", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"HostIp", (Object)"0.0.0.0", (Object)"HostPort", (Object)"49199")))).build()).resolvConfPath("/etc/resolv.conf").driver("aufs").execDriver("native-0.1").volumes((Map)ImmutableMap.of()).volumesRW((Map)ImmutableMap.of()).command("").status("").hostConfig(HostConfig.builder().publishAllPorts(true).build()).ports((List)ImmutableList.of()).build();
        ProviderMetadata providerMetadata = (ProviderMetadata)EasyMock.createMock(ProviderMetadata.class);
        EasyMock.expect((Object)providerMetadata.getEndpoint()).andReturn((Object)"http://127.0.0.1:4243");
        EasyMock.replay((Object[])new Object[]{providerMetadata});
        GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(GroupNamingConvention.Factory.class);
        Supplier<Map<String, ? extends Image>> images = new Supplier<Map<String, ? extends Image>>(){

            public Map<String, ? extends Image> get() {
                OperatingSystem os = OperatingSystem.builder().description("Ubuntu 12.04 64bit").family(OsFamily.UBUNTU).version("12.04").is64Bit(true).build();
                return ImmutableMap.of((Object)"af0f59f1c19eef9471c3b8c8d587c39b8f130560b54f3766931b37d76d5de4b6", (Object)new ImageBuilder().ids("af0f59f1c19eef9471c3b8c8d587c39b8f130560b54f3766931b37d76d5de4b6").name("ubuntu").description("Ubuntu 12.04 64bit").operatingSystem(os).status(Image.Status.AVAILABLE).build());
            }
        };
        Supplier<Set<? extends Location>> locations = new Supplier<Set<? extends Location>>(){

            public Set<? extends Location> get() {
                return ImmutableSet.of((Object)new LocationBuilder().id("docker").description("http://localhost:2375").scope(LocationScope.PROVIDER).build());
            }
        };
        this.credentials = LoginCredentials.builder().user("foo").password("bar").build();
        this.function = new ContainerToNodeMetadata(providerMetadata, this.toPortableStatus(), namingConvention, (Supplier)images, (Supplier)locations);
    }

    private Function<State, NodeMetadata.Status> toPortableStatus() {
        StateToStatus function = (StateToStatus)EasyMock.createMock(StateToStatus.class);
        EasyMock.expect((Object)function.apply((State)EasyMock.anyObject(State.class))).andReturn((Object)NodeMetadata.Status.RUNNING);
        EasyMock.replay((Object[])new Object[]{function});
        return function;
    }

    public void testVirtualMachineToNodeMetadata() {
        Container mockContainer = this.mockContainer();
        NodeMetadata node = this.function.apply(mockContainer);
        EasyMock.verify((Object[])new Object[]{mockContainer});
        Assert.assertEquals((String)node.getId(), (String)"6d35806c1bd2b25cd92bba2d2c2c5169dc2156f53ab45c2b62d76e2d2fee14a9");
        Assert.assertEquals((String)node.getGroup(), (String)"hopeful_mclean");
        Assert.assertEquals((String)node.getImageId(), (String)"af0f59f1c19eef9471c3b8c8d587c39b8f130560b54f3766931b37d76d5de4b6");
        Assert.assertEquals((int)node.getLoginPort(), (int)49199);
        Assert.assertEquals((int)node.getPrivateAddresses().size(), (int)1);
        Assert.assertEquals((int)node.getPublicAddresses().size(), (int)1);
    }

    private Container mockContainer() {
        Container mockContainer = (Container)EasyMock.createMock(Container.class);
        EasyMock.expect((Object)mockContainer.id()).andReturn((Object)this.container.id());
        EasyMock.expect((Object)mockContainer.name()).andReturn((Object)this.container.name());
        EasyMock.expect((Object)mockContainer.config()).andReturn((Object)this.container.config()).anyTimes();
        EasyMock.expect((Object)mockContainer.networkSettings()).andReturn((Object)this.container.networkSettings()).anyTimes();
        EasyMock.expect((Object)mockContainer.state()).andReturn((Object)this.container.state());
        EasyMock.expect((Object)mockContainer.image()).andReturn((Object)this.container.image()).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockContainer});
        return mockContainer;
    }
}

